/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.extender.internal.scanner;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.web.extender.internal.scanner.WarScanner;

public class DefaultWarScanner
implements WarScanner {
    private static final String WAR_EXT = ".war";
    private static final String SLASH = "/";
    private static final String WEB_INF = "WEB-INF";
    private static final Log log = LogFactory.getLog((Class)DefaultWarScanner.class);

    public boolean isWar(Bundle bundle) {
        boolean trace = log.isTraceEnabled();
        boolean isWar = false;
        if (trace) {
            log.trace((Object)("Scanning bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)bundle)));
        }
        if (bundle == null) {
            return false;
        }
        String location = bundle.getLocation();
        if (location != null) {
            if (location.endsWith(SLASH)) {
                location = location.substring(0, location.length() - 1);
            }
            if (trace) {
                log.trace((Object)("Scanning for war bundle location " + location));
            }
            if (isWar = location.endsWith(WAR_EXT)) {
                if (trace) {
                    log.trace((Object)("Location [" + location + "] has " + WAR_EXT + " extension; considering the bundle a WAR"));
                }
                return true;
            }
            if (trace) {
                log.trace((Object)("Location [" + location + "] doesn't indicate a WAR; scanning the presence of /" + WEB_INF + SLASH));
            }
        }
        return this.isWebInfPresent(bundle);
    }

    private boolean isWebInfPresent(Bundle bundle) {
        if (!this.hasEntry(bundle, SLASH, WEB_INF)) {
            return this.hasEntry(bundle, WEB_INF, null);
        }
        return true;
    }

    private boolean hasEntry(Bundle bundle, String path, String pattern) {
        Enumeration enm = bundle.findEntries(path, pattern, false);
        return enm != null && enm.hasMoreElements();
    }
}

