/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.extender.internal.activator;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.OsgiException;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.web.deployer.ContextPathStrategy;
import org.springframework.osgi.web.deployer.WarDeployer;
import org.springframework.osgi.web.deployer.support.DefaultContextPathStrategy;
import org.springframework.osgi.web.deployer.tomcat.TomcatWarDeployer;
import org.springframework.osgi.web.extender.internal.scanner.DefaultWarScanner;
import org.springframework.osgi.web.extender.internal.scanner.WarScanner;
import org.springframework.util.ObjectUtils;

public class WarListenerConfiguration
implements DisposableBean {
    private static final Log log = LogFactory.getLog((Class)WarListenerConfiguration.class);
    private static final String WAR_SCANNER_NAME = "warScanner";
    private static final String WAR_DEPLOYER_NAME = "warDeployer";
    private static final String CONTEXT_PATH_STRATEGY_NAME = "contextPathStrategy";
    private static final String PROPERTIES_NAME = "extenderProperties";
    private static final String UNDEPLOY_WARS_AT_SHUTDOWN = "undeploy.wars.at.shutdown";
    private static final String EXTENDER_CFG_LOCATION = "META-INF/spring/extender";
    private static final String XML_PATTERN = "*.xml";
    private static final boolean UNDEPLOY_WARS_AT_SHUTDOWN_DEFAULT = false;
    private ConfigurableOsgiBundleApplicationContext extenderConfiguration;
    private final WarScanner warScanner;
    private final WarDeployer warDeployer;
    private final ContextPathStrategy contextPathStrategy;
    private final boolean undeployWarsAtShutdown;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarListenerConfiguration(BundleContext bundleContext) {
        Bundle bundle = bundleContext.getBundle();
        Properties properties = new Properties(this.createDefaultProperties());
        Enumeration enm = bundle.findEntries(EXTENDER_CFG_LOCATION, XML_PATTERN, false);
        if (enm == null) {
            log.info((Object)"No custom extender configuration detected; using defaults...");
            this.warScanner = this.createDefaultWarScanner();
            this.warDeployer = this.createDefaultWarDeployer(bundleContext);
            this.contextPathStrategy = this.createDefaultContextPathStrategy();
        } else {
            Object[] configs = this.copyEnumerationToList(enm);
            log.info((Object)("Detected extender custom configurations at " + ObjectUtils.nullSafeToString((Object[])configs)));
            OsgiBundleXmlApplicationContext context = new OsgiBundleXmlApplicationContext((String[])configs);
            context.setBundleContext(bundleContext);
            context.refresh();
            Object object = this.lock;
            synchronized (object) {
                this.extenderConfiguration = context;
            }
            WarScanner warScanner = context.containsBean(WAR_SCANNER_NAME) ? (WarScanner)context.getBean(WAR_SCANNER_NAME, WarScanner.class) : (this.warScanner = this.createDefaultWarScanner());
            WarDeployer warDeployer = context.containsBean(WAR_DEPLOYER_NAME) ? (WarDeployer)context.getBean(WAR_DEPLOYER_NAME, WarDeployer.class) : (this.warDeployer = this.createDefaultWarDeployer(bundleContext));
            ContextPathStrategy contextPathStrategy = context.containsBean(CONTEXT_PATH_STRATEGY_NAME) ? (ContextPathStrategy)context.getBean(CONTEXT_PATH_STRATEGY_NAME, ContextPathStrategy.class) : (this.contextPathStrategy = this.createDefaultContextPathStrategy());
            if (context.containsBean(PROPERTIES_NAME)) {
                Properties customProperties = (Properties)context.getBean(PROPERTIES_NAME, Properties.class);
                Enumeration<?> propertyKey = customProperties.propertyNames();
                while (propertyKey.hasMoreElements()) {
                    String property = (String)propertyKey.nextElement();
                    properties.setProperty(property, customProperties.getProperty(property));
                }
            }
        }
        this.undeployWarsAtShutdown = this.getUndeployWarsAtShutdown(properties);
    }

    private String[] copyEnumerationToList(Enumeration enm) {
        ArrayList<String> urls = new ArrayList<String>(4);
        while (enm != null && enm.hasMoreElements()) {
            URL configURL = (URL)enm.nextElement();
            String configURLAsString = configURL.toExternalForm();
            try {
                urls.add(URLDecoder.decode(configURLAsString, "UTF8"));
            }
            catch (UnsupportedEncodingException uee) {
                log.warn((Object)"UTF8 encoding not supported, using the platform default");
                urls.add(URLDecoder.decode(configURLAsString));
            }
        }
        return urls.toArray(new String[urls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.extenderConfiguration != null) {
                this.extenderConfiguration.close();
                this.extenderConfiguration = null;
            }
        }
    }

    private Properties createDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(UNDEPLOY_WARS_AT_SHUTDOWN, "false");
        return properties;
    }

    private WarScanner createDefaultWarScanner() {
        return new DefaultWarScanner();
    }

    private WarDeployer createDefaultWarDeployer(BundleContext bundleContext) {
        TomcatWarDeployer deployer = new TomcatWarDeployer();
        deployer.setBundleContext(bundleContext);
        try {
            deployer.afterPropertiesSet();
            return deployer;
        }
        catch (Exception ex) {
            throw new OsgiException("Cannot create Tomcat deployer", (Throwable)ex);
        }
    }

    private ContextPathStrategy createDefaultContextPathStrategy() {
        return new DefaultContextPathStrategy();
    }

    private boolean getUndeployWarsAtShutdown(Properties properties) {
        return Boolean.valueOf(properties.getProperty(UNDEPLOY_WARS_AT_SHUTDOWN));
    }

    public WarScanner getWarScanner() {
        return this.warScanner;
    }

    public WarDeployer getWarDeployer() {
        return this.warDeployer;
    }

    public ContextPathStrategy getContextPathStrategy() {
        return this.contextPathStrategy;
    }

    public boolean shouldUndeployWarsAtShutdown() {
        return this.undeployWarsAtShutdown;
    }
}

