/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class ScopedProxyUtils {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";

    public static BeanDefinitionHolder createScopedProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        RootBeanDefinition scopedProxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
        scopedProxyDefinition.setOriginatingBeanDefinition(definition.getBeanDefinition());
        scopedProxyDefinition.setSource(definition.getSource());
        scopedProxyDefinition.setRole(2);
        String targetBeanName = ScopedProxyUtils.getTargetBeanName(originalBeanName);
        scopedProxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
        } else {
            scopedProxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.FALSE);
        }
        if (targetDefinition instanceof AbstractBeanDefinition) {
            scopedProxyDefinition.copyQualifiersFrom((AbstractBeanDefinition)targetDefinition);
        }
        scopedProxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        scopedProxyDefinition.setPrimary(targetDefinition.isPrimary());
        targetDefinition.setAutowireCandidate(false);
        targetDefinition.setPrimary(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder((BeanDefinition)scopedProxyDefinition, originalBeanName, definition.getAliases());
    }

    public static String getTargetBeanName(String originalBeanName) {
        return TARGET_NAME_PREFIX + originalBeanName;
    }
}

