/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.JdkVersion;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        if (this.shouldUseBackport(element)) {
            return "org.springframework.scheduling.backportconcurrent.ThreadPoolTaskExecutor";
        }
        return "org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String queueCapacity;
        String keepAliveSeconds = element.getAttribute("keep-alive");
        if (StringUtils.hasText((String)keepAliveSeconds)) {
            builder.addPropertyValue("keepAliveSeconds", (Object)keepAliveSeconds);
        }
        if (StringUtils.hasText((String)(queueCapacity = element.getAttribute("queue-capacity")))) {
            builder.addPropertyValue("queueCapacity", (Object)queueCapacity);
        }
        this.configureRejectionPolicy(element, builder);
        String poolSize = element.getAttribute("pool-size");
        if (!StringUtils.hasText((String)poolSize)) {
            return;
        }
        Integer[] range = null;
        try {
            int separatorIndex = poolSize.indexOf(45);
            if (separatorIndex != -1) {
                range = new Integer[]{Integer.valueOf(poolSize.substring(0, separatorIndex)), Integer.valueOf(poolSize.substring(separatorIndex + 1, poolSize.length()))};
                if (range[0] > range[1]) {
                    parserContext.getReaderContext().error("Lower bound of pool-size range must not exceed the upper bound.", (Object)element);
                }
                if (!StringUtils.hasText((String)queueCapacity)) {
                    if (range[0] == 0) {
                        builder.addPropertyValue("allowCoreThreadTimeOut", (Object)true);
                        range[0] = range[1];
                    } else {
                        parserContext.getReaderContext().error("A non-zero lower bound for the size range requires a queue-capacity value.", (Object)element);
                    }
                }
            } else {
                Integer value = Integer.valueOf(poolSize);
                range = new Integer[]{value, value};
            }
        }
        catch (NumberFormatException ex) {
            parserContext.getReaderContext().error("Invalid pool-size value [" + poolSize + "]: only single " + "maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported.", (Object)element, (Throwable)ex);
        }
        if (range != null) {
            builder.addPropertyValue("corePoolSize", (Object)range[0]);
            builder.addPropertyValue("maxPoolSize", (Object)range[1]);
        }
    }

    private void configureRejectionPolicy(Element element, BeanDefinitionBuilder builder) {
        String rejectionPolicy = element.getAttribute("rejection-policy");
        if (!StringUtils.hasText((String)rejectionPolicy)) {
            return;
        }
        String prefix = "java.util.concurrent.ThreadPoolExecutor.";
        if (builder.getRawBeanDefinition().getBeanClassName().contains("backport")) {
            prefix = "edu.emory.mathcs.backport." + prefix;
        }
        String policyClassName = rejectionPolicy.equals("ABORT") ? String.valueOf(prefix) + "AbortPolicy" : (rejectionPolicy.equals("CALLER_RUNS") ? String.valueOf(prefix) + "CallerRunsPolicy" : (rejectionPolicy.equals("DISCARD") ? String.valueOf(prefix) + "DiscardPolicy" : (rejectionPolicy.equals("DISCARD_OLDEST") ? String.valueOf(prefix) + "DiscardOldestPolicy" : rejectionPolicy)));
        builder.addPropertyValue("rejectedExecutionHandler", (Object)new RootBeanDefinition(policyClassName));
    }

    private boolean shouldUseBackport(Element element) {
        String poolSize = element.getAttribute("pool-size");
        return StringUtils.hasText((String)poolSize) && poolSize.startsWith("0") && JdkVersion.getMajorJavaVersion() < 3;
    }
}

