/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.datetime.joda.JodaTimeFormattingConfigurer;
import org.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import org.springframework.format.number.NumberFormatter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingConversionServiceFactoryBean
implements FactoryBean<ConversionService>,
InitializingBean {
    private ConversionService parent;
    private FormattingConversionService conversionService;

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public void afterPropertiesSet() {
        this.initConversionService();
        this.installNumberFormatting();
        this.installJodaTimeFormattingIfPresent();
    }

    public ConversionService getObject() {
        return this.conversionService;
    }

    public Class<? extends ConversionService> getObjectType() {
        return ConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void initConversionService() {
        this.conversionService = this.parent != null ? new FormattingConversionService(this.parent) : new FormattingConversionService();
    }

    private void installNumberFormatting() {
        this.conversionService.addFormatterForFieldType(Number.class, new NumberFormatter());
        this.conversionService.addFormatterForFieldAnnotation((AnnotationFormatterFactory)new NumberFormatAnnotationFormatterFactory());
    }

    private void installJodaTimeFormattingIfPresent() {
        if (ClassUtils.isPresent((String)"org.joda.time.DateTime", (ClassLoader)FormattingConversionService.class.getClassLoader())) {
            new JodaTimeFormattingConfigurer().installJodaTimeFormatting(this.conversionService);
        }
    }
}

