/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Set;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConditionalGenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingConversionService
implements FormatterRegistry,
ConversionService {
    private GenericConversionService conversionService = new GenericConversionService();

    public FormattingConversionService() {
        this.conversionService.setParent((ConversionService)new DefaultConversionService());
    }

    public FormattingConversionService(ConversionService parent) {
        this.conversionService.setParent(parent);
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.conversionService.addGenericConverter(fieldType, String.class, (GenericConverter)new PrinterConverter(printer, (ConversionService)this.conversionService));
        this.conversionService.addGenericConverter(String.class, fieldType, (GenericConverter)new ParserConverter(parser, (ConversionService)this.conversionService));
    }

    @Override
    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.conversionService.addGenericConverter(fieldType, String.class, (GenericConverter)new PrinterConverter(formatter, (ConversionService)this.conversionService));
        this.conversionService.addGenericConverter(String.class, fieldType, (GenericConverter)new ParserConverter(formatter, (ConversionService)this.conversionService));
    }

    public void addFormatterForFieldAnnotation(final AnnotationFormatterFactory annotationFormatterFactory) {
        final Class<? extends Annotation> annotationType = this.resolveAnnotationType(annotationFormatterFactory);
        if (annotationType == null) {
            throw new IllegalArgumentException("Unable to extract parameterized Annotation type argument from AnnotationFormatterFactory [" + annotationFormatterFactory.getClass().getName() + "]; does the factory parameterize the <A extends Annotation> generic type?");
        }
        Set<Class<?>> fieldTypes = annotationFormatterFactory.getFieldTypes();
        for (final Class<?> fieldType : fieldTypes) {
            this.conversionService.addGenericConverter(fieldType, String.class, (GenericConverter)new ConditionalGenericConverter(){

                public boolean matches(TypeDescriptor sourceFieldType, TypeDescriptor targetFieldType) {
                    return sourceFieldType.getAnnotation(annotationType) != null;
                }

                public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                    Printer<?> printer = annotationFormatterFactory.getPrinter(sourceType.getAnnotation(annotationType), sourceType.getType());
                    return new PrinterConverter(printer, (ConversionService)FormattingConversionService.this.conversionService).convert(source, sourceType, targetType);
                }

                public String toString() {
                    return "@" + annotationType.getName() + " " + fieldType.getName() + " -> " + String.class.getName();
                }
            });
            this.conversionService.addGenericConverter(String.class, fieldType, (GenericConverter)new ConditionalGenericConverter(){

                public boolean matches(TypeDescriptor sourceFieldType, TypeDescriptor targetFieldType) {
                    return targetFieldType.getAnnotation(annotationType) != null;
                }

                public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
                    Parser<?> parser = annotationFormatterFactory.getParser(targetType.getAnnotation(annotationType), targetType.getType());
                    return new ParserConverter(parser, (ConversionService)FormattingConversionService.this.conversionService).convert(source, sourceType, targetType);
                }

                public String toString() {
                    return String.valueOf(String.class.getName()) + " -> @" + annotationType.getName() + " " + fieldType.getName();
                }
            });
        }
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        return this.conversionService;
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(TypeDescriptor.valueOf(sourceType), TypeDescriptor.valueOf(targetType));
    }

    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.convert(source, TypeDescriptor.forObject((Object)source), TypeDescriptor.valueOf(targetType));
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.convert(source, sourceType, targetType);
    }

    public String toString() {
        return this.conversionService.toString();
    }

    private Class<? extends Annotation> resolveAnnotationType(AnnotationFormatterFactory<?> annotationFormatterFactory) {
        return GenericTypeResolver.resolveTypeArgument(annotationFormatterFactory.getClass(), AnnotationFormatterFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParserConverter
    implements GenericConverter {
        private Parser<?> parser;
        private ConversionService conversionService;

        public ParserConverter(Parser<?> parser, ConversionService conversionService) {
            this.parser = parser;
            this.conversionService = conversionService;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            Object parsedValue;
            String submittedValue = (String)source;
            if (submittedValue.isEmpty()) {
                return null;
            }
            try {
                parsedValue = this.parser.parse(submittedValue, LocaleContextHolder.getLocale());
            }
            catch (ParseException e) {
                throw new ConversionFailedException(sourceType, targetType, source, (Throwable)e);
            }
            TypeDescriptor parsedObjectType = TypeDescriptor.valueOf(parsedValue.getClass());
            if (!parsedObjectType.isAssignableTo(targetType)) {
                try {
                    parsedValue = this.conversionService.convert(parsedValue, parsedObjectType, targetType);
                }
                catch (ConversionFailedException e) {
                    throw new ConversionFailedException(sourceType, targetType, source, (Throwable)e);
                }
            }
            return parsedValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrinterConverter
    implements GenericConverter {
        private TypeDescriptor printerObjectType;
        private Printer printer;
        private ConversionService conversionService;

        public PrinterConverter(Printer<?> printer, ConversionService conversionService) {
            this.printerObjectType = TypeDescriptor.valueOf(this.resolvePrinterObjectType(printer));
            this.printer = printer;
            this.conversionService = conversionService;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!sourceType.isAssignableTo(this.printerObjectType)) {
                source = this.conversionService.convert(source, sourceType, this.printerObjectType);
            }
            return source != null ? this.printer.print(source, LocaleContextHolder.getLocale()) : "";
        }

        private Class<?> resolvePrinterObjectType(Printer<?> printer) {
            return GenericTypeResolver.resolveTypeArgument(printer.getClass(), Printer.class);
        }
    }
}

