/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.util.StringUtils;

final class ObjectToArrayConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public ObjectToArrayConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (sourceType.typeEquals(String.class)) {
            String string = (String)source;
            String[] fields = StringUtils.commaDelimitedListToStringArray(string);
            if (sourceType.isAssignableTo(targetElementType)) {
                return fields;
            }
            Object target = Array.newInstance(targetElementType.getType(), fields.length);
            GenericConverter converter = this.conversionService.getConverter(sourceType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceType, targetElementType);
            }
            int i = 0;
            while (i < fields.length) {
                Array.set(target, i, ConversionUtils.invokeConverter(converter, fields[i], sourceType, targetElementType));
                ++i;
            }
            return target;
        }
        Object target = Array.newInstance(targetElementType.getType(), 1);
        if (sourceType.isAssignableTo(targetElementType)) {
            Array.set(target, 0, source);
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceType, targetElementType);
            }
            Array.set(target, 0, ConversionUtils.invokeConverter(converter, source, sourceType, targetElementType));
        }
        return target;
    }
}

