/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.core.convert.support.MapEntryConverter;

final class MapToObjectConverter
implements GenericConverter {
    private static final String DELIMITER = " ";
    private final GenericConversionService conversionService;

    public MapToObjectConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Map sourceMap = (Map)source;
        if (sourceMap.size() == 0) {
            if (targetType.typeEquals(String.class)) {
                return "";
            }
            return null;
        }
        if (targetType.typeEquals(String.class)) {
            TypeDescriptor sourceKeyType = sourceType.getMapKeyTypeDescriptor();
            TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
            boolean keysCompatible = false;
            if (sourceKeyType == TypeDescriptor.NULL || sourceKeyType.isAssignableTo(targetType)) {
                keysCompatible = true;
            }
            boolean valuesCompatible = false;
            if (sourceValueType == TypeDescriptor.NULL || sourceValueType.isAssignableTo(targetType)) {
                valuesCompatible = true;
            }
            if (keysCompatible && valuesCompatible) {
                StringBuilder string = new StringBuilder();
                int i = 0;
                Iterator iterator = sourceMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry mapEntry = entry = iterator.next();
                    if (i > 0) {
                        string.append(DELIMITER);
                    }
                    String property = mapEntry.getKey() + "=" + mapEntry.getValue();
                    string.append(property);
                    ++i;
                }
                return string.toString();
            }
            MapEntryConverter converter = new MapEntryConverter(sourceKeyType, sourceValueType, targetType, targetType, keysCompatible, valuesCompatible, this.conversionService);
            StringBuilder string = new StringBuilder();
            int i = 0;
            Iterator iterator = sourceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry mapEntry = entry = iterator.next();
                if (i > 0) {
                    string.append(DELIMITER);
                }
                Object key = converter.convertKey(mapEntry.getKey());
                Object value = converter.convertValue(mapEntry.getValue());
                String property = key + "=" + value;
                string.append(property);
                ++i;
            }
            return string.toString();
        }
        TypeDescriptor sourceValueType = sourceType.getMapValueTypeDescriptor();
        boolean valuesCompatible = false;
        if (sourceValueType == TypeDescriptor.NULL || sourceValueType.isAssignableTo(targetType)) {
            valuesCompatible = true;
        }
        if (valuesCompatible) {
            return sourceMap.values().iterator().next();
        }
        MapEntryConverter converter = new MapEntryConverter(sourceValueType, sourceValueType, targetType, targetType, true, valuesCompatible, this.conversionService);
        Object value = sourceMap.values().iterator().next();
        return converter.convertValue(value);
    }
}

