/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ArrayToArrayConverter;
import org.springframework.core.convert.support.ArrayToCollectionConverter;
import org.springframework.core.convert.support.ArrayToMapConverter;
import org.springframework.core.convert.support.ArrayToObjectConverter;
import org.springframework.core.convert.support.CollectionToArrayConverter;
import org.springframework.core.convert.support.CollectionToCollectionConverter;
import org.springframework.core.convert.support.CollectionToMapConverter;
import org.springframework.core.convert.support.CollectionToObjectConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.ConverterMatcher;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.core.convert.support.MapToArrayConverter;
import org.springframework.core.convert.support.MapToCollectionConverter;
import org.springframework.core.convert.support.MapToMapConverter;
import org.springframework.core.convert.support.MapToObjectConverter;
import org.springframework.core.convert.support.ObjectToArrayConverter;
import org.springframework.core.convert.support.ObjectToCollectionConverter;
import org.springframework.core.convert.support.ObjectToMapConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericConversionService
implements ConversionService,
ConverterRegistry {
    private static final Log logger = LogFactory.getLog(GenericConversionService.class);
    private static final GenericConverter NO_OP_CONVERTER = new GenericConverter(){

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source;
        }
    };
    private final Map<Class<?>, Map<Class<?>, MatchableConverters>> converters = new HashMap(36);
    private ConversionService parent;
    private GenericConverter parentConverterAdapter = new GenericConverter(){

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return GenericConversionService.this.parent.convert(source, sourceType, targetType);
        }
    };

    public GenericConversionService() {
        this.addGenericConverter(Object[].class, Object[].class, new ArrayToArrayConverter(this));
        this.addGenericConverter(Object[].class, Collection.class, new ArrayToCollectionConverter(this));
        this.addGenericConverter(Object[].class, Map.class, new ArrayToMapConverter(this));
        this.addGenericConverter(Object[].class, Object.class, new ArrayToObjectConverter(this));
        this.addGenericConverter(Collection.class, Collection.class, new CollectionToCollectionConverter(this));
        this.addGenericConverter(Collection.class, Object[].class, new CollectionToArrayConverter(this));
        this.addGenericConverter(Collection.class, Map.class, new CollectionToMapConverter(this));
        this.addGenericConverter(Collection.class, Object.class, new CollectionToObjectConverter(this));
        this.addGenericConverter(Map.class, Map.class, new MapToMapConverter(this));
        this.addGenericConverter(Map.class, Object[].class, new MapToArrayConverter(this));
        this.addGenericConverter(Map.class, Collection.class, new MapToCollectionConverter(this));
        this.addGenericConverter(Map.class, Object.class, new MapToObjectConverter(this));
        this.addGenericConverter(Object.class, Object[].class, new ObjectToArrayConverter(this));
        this.addGenericConverter(Object.class, Collection.class, new ObjectToCollectionConverter(this));
        this.addGenericConverter(Object.class, Map.class, new ObjectToMapConverter(this));
    }

    public void setConverters(Set<Converter<?, ?>> converters) {
        for (Converter<?, ?> converter : converters) {
            this.addConverter(converter);
        }
    }

    public void setConverterFactories(Set<ConverterFactory<?, ?>> converters) {
        for (ConverterFactory<?, ?> converterFactory : converters) {
            this.addConverterFactory(converterFactory);
        }
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    public ConversionService getParent() {
        return this.parent;
    }

    @Override
    public void addConverter(Converter<?, ?> converter) {
        Class<?>[] typeInfo = this.getRequiredTypeInfo(converter, Converter.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetType <T> your Converter<S, T> converts between; declare these types or implement ConverterInfo");
        }
        Class<?> sourceType = typeInfo[0];
        Class<?> targetType = typeInfo[1];
        this.addConverter(sourceType, targetType, converter);
    }

    @Override
    public void addConverterFactory(ConverterFactory<?, ?> converterFactory) {
        Class<?>[] typeInfo = this.getRequiredTypeInfo(converterFactory, ConverterFactory.class);
        if (typeInfo == null) {
            throw new IllegalArgumentException("Unable to the determine sourceType <S> and targetRangeType R your ConverterFactory<S, R> converts between; declare these types or implement ConverterInfo");
        }
        Class<?> sourceType = typeInfo[0];
        Class<?> targetType = typeInfo[1];
        this.addConverterFactory(sourceType, targetType, converterFactory);
    }

    @Override
    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.getSourceConverterMap(sourceType).remove(targetType);
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.canConvert(TypeDescriptor.valueOf(sourceType), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        return (T)this.convert(source, TypeDescriptor.forObject(source), TypeDescriptor.valueOf(targetType));
    }

    @Override
    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        this.assertNotNull(sourceType, targetType);
        if (sourceType == TypeDescriptor.NULL || targetType == TypeDescriptor.NULL) {
            return true;
        }
        return this.getConverter(sourceType, targetType) != null;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        this.assertNotNull(sourceType, targetType);
        if (sourceType == TypeDescriptor.NULL) {
            Assert.isTrue(source == null, "The source must be null if sourceType == TypeDescriptor.NULL");
            return this.convertNullSource(sourceType, targetType);
        }
        if (targetType == TypeDescriptor.NULL) {
            return null;
        }
        GenericConverter converter = this.getConverter(sourceType, targetType);
        if (converter == null) {
            throw new ConverterNotFoundException(sourceType, targetType);
        }
        return ConversionUtils.invokeConverter(converter, source, sourceType, targetType);
    }

    public void addGenericConverter(Class<?> sourceType, Class<?> targetType, GenericConverter converter) {
        this.getMatchableConvertersList(sourceType, targetType).add(converter);
    }

    public void addGenericConverter(Class<?> sourceType, Class<?> targetType, GenericConverter converter, ConverterMatcher matcher) {
        this.getMatchableConvertersList(sourceType, targetType).add(matcher, converter);
    }

    public void addConverter(Class<?> sourceType, Class<?> targetType, Converter<?, ?> converter) {
        this.addGenericConverter(sourceType, targetType, new ConverterAdapter(converter));
    }

    public void addConverterFactory(Class<?> sourceType, Class<?> targetType, ConverterFactory<?, ?> converterFactory) {
        this.addGenericConverter(sourceType, targetType, new ConverterFactoryAdapter(converterFactory));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConversionService converters = ").append("\n");
        for (Map<Class<?>, MatchableConverters> targetConverters : this.converters.values()) {
            for (MatchableConverters matchable : targetConverters.values()) {
                builder.append("\t");
                builder.append(matchable);
                builder.append("\n");
            }
        }
        if (this.parent != null) {
            builder.append("parent = ").append(this.parent);
        }
        return builder.toString();
    }

    protected Object convertNullSource(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.isPrimitive()) {
            throw new ConversionFailedException(sourceType, targetType, null, new IllegalArgumentException("A null value cannot be assigned to a primitive type"));
        }
        return null;
    }

    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericConverter converter = this.findConverterForClassPair(sourceType, targetType);
        if (converter != null) {
            return converter;
        }
        if (this.parent != null && this.parent.canConvert(sourceType, targetType)) {
            return this.parentConverterAdapter;
        }
        return this.getDefaultConverter(sourceType, targetType);
    }

    protected GenericConverter getDefaultConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.isAssignableTo(targetType)) {
            return NO_OP_CONVERTER;
        }
        return null;
    }

    private Class<?>[] getRequiredTypeInfo(Object converter, Class<?> genericIfc) {
        return GenericTypeResolver.resolveTypeArguments(converter.getClass(), genericIfc);
    }

    private MatchableConverters getMatchableConvertersList(Class<?> sourceType, Class<?> targetType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.getSourceConverterMap(sourceType);
        MatchableConverters matchable = sourceMap.get(targetType);
        if (matchable == null) {
            matchable = new MatchableConverters();
            sourceMap.put(targetType, matchable);
        }
        return matchable;
    }

    private Map<Class<?>, MatchableConverters> getSourceConverterMap(Class<?> sourceType) {
        Map<Class<?>, MatchableConverters> sourceMap = this.converters.get(sourceType);
        if (sourceMap == null) {
            sourceMap = new HashMap();
            this.converters.put(sourceType, sourceMap);
        }
        return sourceMap;
    }

    private void assertNotNull(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull(sourceType, "The sourceType to convert to is required");
        Assert.notNull(targetType, "The targetType to convert to is required");
    }

    private GenericConverter findConverterForClassPair(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Class<?> sourceObjectType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for Converter to convert from " + sourceType + " to " + targetType));
        }
        if ((sourceObjectType = sourceType.getObjectType()).isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(sourceObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(currentClass);
                GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            Map<Class<?>, MatchableConverters> objectConverters = this.getTargetConvertersForSource(Object.class);
            return this.getMatchingConverterForTarget(sourceType, targetType, objectConverters);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(sourceObjectType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            Map<Class<?>, MatchableConverters> converters = this.getTargetConvertersForSource(currentClass);
            GenericConverter converter = this.getMatchingConverterForTarget(sourceType, targetType, converters);
            if (converter != null) {
                return converter;
            }
            if (currentClass.isArray()) {
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() == null) continue;
                classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                continue;
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                classQueue.addFirst(ifc);
                ++n3;
            }
            if (currentClass.getSuperclass() == null) continue;
            classQueue.addFirst(currentClass.getSuperclass());
        }
        return null;
    }

    private Map<Class<?>, MatchableConverters> getTargetConvertersForSource(Class<?> sourceType) {
        Map<Class<Object>, MatchableConverters> converters = this.converters.get(sourceType);
        if (converters == null) {
            converters = Collections.emptyMap();
        }
        return converters;
    }

    private GenericConverter getMatchingConverterForTarget(TypeDescriptor sourceType, TypeDescriptor targetType, Map<Class<?>, MatchableConverters> converters) {
        Class<?> targetObjectType = targetType.getObjectType();
        if (targetObjectType.isInterface()) {
            LinkedList classQueue = new LinkedList();
            classQueue.addFirst(targetObjectType);
            while (!classQueue.isEmpty()) {
                Class<?>[] interfaces;
                Class currentClass = (Class)classQueue.removeLast();
                MatchableConverters matchable = converters.get(currentClass);
                GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
                if (converter != null) {
                    return converter;
                }
                Class<?>[] classArray = interfaces = currentClass.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> ifc = classArray[n2];
                    classQueue.addFirst(ifc);
                    ++n2;
                }
            }
            return this.matchConverter(converters.get(Object.class), sourceType, targetType);
        }
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(targetObjectType);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            MatchableConverters matchable = converters.get(currentClass);
            GenericConverter converter = this.matchConverter(matchable, sourceType, targetType);
            if (converter != null) {
                return converter;
            }
            if (currentClass.isArray()) {
                Class<?> componentType = ClassUtils.resolvePrimitiveIfNecessary(currentClass.getComponentType());
                if (componentType.getSuperclass() == null) continue;
                classQueue.addFirst(Array.newInstance(componentType.getSuperclass(), 0).getClass());
                continue;
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n3 = 0;
            while (n3 < n) {
                Class<?> ifc = classArray[n3];
                classQueue.addFirst(ifc);
                ++n3;
            }
            if (currentClass.getSuperclass() == null) continue;
            classQueue.addFirst(currentClass.getSuperclass());
        }
        return null;
    }

    private GenericConverter matchConverter(MatchableConverters matchable, TypeDescriptor sourceFieldType, TypeDescriptor targetFieldType) {
        return matchable != null ? matchable.matchConverter(sourceFieldType, targetFieldType) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterAdapter
    implements GenericConverter {
        private final Converter converter;

        public ConverterAdapter(Converter<?, ?> converter) {
            this.converter = converter;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source);
        }

        public String toString() {
            return this.converter.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConverterFactoryAdapter
    implements GenericConverter {
        private final ConverterFactory converterFactory;

        public ConverterFactoryAdapter(ConverterFactory<?, ?> converterFactory) {
            this.converterFactory = converterFactory;
        }

        @Override
        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return GenericConversionService.this.convertNullSource(sourceType, targetType);
            }
            return this.converterFactory.getConverter(targetType.getObjectType()).convert(source);
        }

        public String toString() {
            return this.converterFactory.toString();
        }
    }

    private static class MatchableConverters {
        private static final ConverterMatcher ALWAYS_MATCHES = new ConverterMatcher(){

            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                return true;
            }
        };
        private LinkedList<MatchableConverter> matchableConverters = new LinkedList();

        private MatchableConverters() {
        }

        public void add(GenericConverter converter) {
            if (converter instanceof ConverterMatcher) {
                this.add((ConverterMatcher)((Object)converter), converter);
            } else {
                this.add(ALWAYS_MATCHES, converter);
            }
        }

        public void add(ConverterMatcher matcher, GenericConverter converter) {
            MatchableConverter matchable = new MatchableConverter(matcher, converter);
            int index = this.matchableConverters.indexOf(matchable);
            if (index == -1) {
                this.matchableConverters.addFirst(new MatchableConverter(matcher, converter));
            } else {
                this.matchableConverters.set(index, matchable);
            }
        }

        public GenericConverter matchConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
            for (MatchableConverter matchable : this.matchableConverters) {
                if (matchable.matches(sourceType, targetType)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Converter Lookup [MATCHED] " + matchable));
                    }
                    return matchable.getConverter();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Converter Lookup [DID NOT MATCH] " + matchable));
            }
            return null;
        }

        public String toString() {
            if (this.matchableConverters.size() == 1) {
                return this.matchableConverters.get(0).toString();
            }
            return "[MatchableConverters = " + this.matchableConverters + "]";
        }

        private static class MatchableConverter {
            private ConverterMatcher matcher;
            private GenericConverter converter;

            public MatchableConverter(ConverterMatcher matcher, GenericConverter converter) {
                this.matcher = matcher;
                this.converter = converter;
            }

            public GenericConverter getConverter() {
                return this.converter;
            }

            public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
                return this.matcher.matches(sourceType, targetType);
            }

            public int hashCode() {
                return this.matcher.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof MatchableConverter)) {
                    return false;
                }
                MatchableConverter matchable = (MatchableConverter)o;
                return this.matcher.equals(matchable.matcher);
            }

            public String toString() {
                if (this.matcher == ALWAYS_MATCHES || this.matcher == this.converter) {
                    return this.converter.toString();
                }
                return "if (" + this.matcher + ") " + this.converter;
            }
        }
    }
}

