/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;

final class ArrayToCollectionConverter
implements GenericConverter {
    private final GenericConversionService conversionService;

    public ArrayToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        int length = Array.getLength(source);
        Collection collection = CollectionFactory.createCollection(targetType.getType(), length);
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (targetElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetElementType)) {
            int i = 0;
            while (i < length) {
                collection.add(Array.get(source, i));
                ++i;
            }
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceElementType, targetElementType);
            }
            int i = 0;
            while (i < length) {
                Object sourceElement = Array.get(source, i);
                Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceElementType, targetElementType);
                collection.add(targetElement);
                ++i;
            }
        }
        return collection;
    }
}

