/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.TypeDescriptor;

public final class ConversionFailedException
extends ConversionException {
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;

    public ConversionFailedException(TypeDescriptor sourceType, TypeDescriptor targetType, Object value, Throwable cause) {
        super(ConversionFailedException.buildDefaultMessage(value, sourceType, targetType, cause), cause);
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public TypeDescriptor getSourceType() {
        return this.sourceType;
    }

    public TypeDescriptor getTargetType() {
        return this.targetType;
    }

    private static String buildDefaultMessage(Object value, TypeDescriptor sourceType, TypeDescriptor targetType, Throwable cause) {
        return "Unable to convert value " + value + " from type [" + sourceType.getName() + "] to type [" + targetType.getName() + "]; reason = '" + cause.getMessage() + "'";
    }
}

