/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;

public class PostProcessorRegistrationPostProcessor
extends ChildPathedBeanFactoryPostProcessor {
    private static Log logger = LogFactory.getLog(PostProcessorRegistrationPostProcessor.class);

    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.registerBeanPostProcessors((ConfigurableListableBeanFactory)beanFactory);
        }
        return beanFactory;
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanPostProcessorChecker(beanFactory, beanProcessorTargetCount));
        ArrayList<Object> priorityOrderedPostProcessors = new ArrayList<Object>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (int i = 0; i < postProcessorNames.length; ++i) {
            if (beanFactory.isTypeMatch(postProcessorNames[i], PriorityOrdered.class)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(postProcessorNames[i]));
                continue;
            }
            if (beanFactory.isTypeMatch(postProcessorNames[i], Ordered.class)) {
                orderedPostProcessorNames.add(postProcessorNames[i]);
                continue;
            }
            nonOrderedPostProcessorNames.add(postProcessorNames[i]);
        }
        Collections.sort(priorityOrderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<Object> orderedPostProcessors = new ArrayList<Object>();
        for (String postProcessorName : orderedPostProcessorNames) {
            orderedPostProcessors.add(beanFactory.getBean(postProcessorName));
        }
        Collections.sort(orderedPostProcessors, new OrderComparator());
        this.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<Object> nonOrderedPostProcessors = new ArrayList<Object>();
        for (String postProcessorName : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add(beanFactory.getBean(postProcessorName));
        }
        this.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
    }

    private void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List postProcessors) {
        for (BeanPostProcessor postProcessor : postProcessors) {
            beanFactory.addBeanPostProcessor(postProcessor);
        }
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, int beanPostProcessorTargetCount) {
            this.beanFactory = beanFactory;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (!(bean instanceof BeanPostProcessor) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && logger.isInfoEnabled()) {
                logger.info((Object)("Bean '" + beanName + "' is not eligible for getting processed by all " + "BeanPostProcessors (for example: not eligible for auto-proxying)"));
            }
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }
    }
}

