/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.PathAware;
import com.mtvnet.boxspring.path.PathManager;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class PathAwarePostProcessor
implements BeanPostProcessor {
    private PathedBeanFactory pathedBeanFactory;
    private PathManager pathManager;

    public PathAwarePostProcessor(PathedBeanFactory pathedBeanFactory, PathManager pathManager) {
        this.pathedBeanFactory = pathedBeanFactory;
        this.pathManager = pathManager;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof PathAware) {
            PathAware pathAwareBean = (PathAware)bean;
            String pathString = new String("/" + beanName);
            PathedBeanFactory localFactory = this.pathedBeanFactory;
            while (!localFactory.isPathRootBeanFactory()) {
                pathString = "/" + localFactory.getBeanName() + pathString;
                localFactory = localFactory.getContainingBeanFactory();
            }
            pathAwareBean.setPath(this.pathManager.parsePath(pathString));
        }
        return bean;
    }
}

