/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.factory;

import com.mtvnet.boxspring.factory.AbstractDynamicObjectFactoryBean;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.ListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicListFactoryBean<T>
extends AbstractDynamicObjectFactoryBean<List<T>, T> {
    @Override
    protected List<T> createDynamicCollection(ListableBeanFactory beanFactory) {
        return new BeanFactoryBackedList(beanFactory);
    }

    public Class<? extends List<T>> getObjectType() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanFactoryBackedList
    extends AbstractList<T> {
        private ListableBeanFactory beanFactory;
        private Comparator<Map.Entry<String, T>> comparator = new Comparator<Map.Entry<String, T>>(){

            @Override
            public int compare(Map.Entry<String, T> o1, Map.Entry<String, T> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        };

        private BeanFactoryBackedList(ListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public T get(int index) {
            Set entries = DynamicListFactoryBean.this.getBeansMap(this.beanFactory).entrySet();
            TreeSet sorted = new TreeSet(this.comparator);
            sorted.addAll(entries);
            Map.Entry entry = (Map.Entry)sorted.toArray()[index];
            return entry.getValue();
        }

        @Override
        public int size() {
            return DynamicListFactoryBean.this.getBeansMap(this.beanFactory).size();
        }
    }
}

