/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.external;

import com.mtvnet.boxspring.external.ExternalBeanSource;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalPathedBeanFactory
implements PathedBeanFactory,
BeanFactoryAware {
    private PathedBeanFactory beanFactory;
    private String beanName;
    private ExternalBeanSource beanSource;

    public boolean containsBean(String name) {
        return this.beanSource.containsBean(name);
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.containsBean(beanName);
    }

    public String[] getAliases(String name) {
        return null;
    }

    public Object getBean(String name) throws BeansException {
        return this.beanSource.getBean(name, null);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return this.beanSource.getBean(name, requiredType);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType, Object ... args) {
        return this.getBean(name, requiredType);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.getBean(name);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(beanName);
        if (bean != null) {
            GenericBeanDefinition bd = new GenericBeanDefinition();
            bd.setBeanClass(bean.getClass());
            return bd;
        }
        throw new NoSuchBeanDefinitionException("No bean named '" + beanName + "' is available.");
    }

    public int getBeanDefinitionCount() {
        return this.beanSource.getBeanCount(null);
    }

    public String[] getBeanDefinitionNames() {
        return this.beanSource.getBeanNames(null).toArray(new String[0]);
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public String[] getBeanNamesForType(Class type) {
        return this.beanSource.getBeanNames(type).toArray(new String[0]);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.getBeanNamesForType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.beanSource.getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return this.getBeansOfType(type);
    }

    @Override
    public PathedBeanFactory getContainingBeanFactory() {
        return this.beanFactory;
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(this.beanName);
        if (bean != null) {
            return bean.getClass();
        }
        throw new NoSuchBeanDefinitionException("No bean named '" + this.beanName + "' is available.");
    }

    public boolean isAlias(String aliasName) {
        return false;
    }

    public boolean isBeanNameInUse(String beanName) {
        return this.beanSource.getBeanNames(null).contains(beanName);
    }

    @Override
    public boolean isPathRootBeanFactory() {
        return this.beanFactory != null;
    }

    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        return false;
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        if (this.containsBean(name)) {
            return true;
        }
        throw new NoSuchBeanDefinitionException(name);
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        return false;
    }

    @Override
    public void loadBeanDefinitions() throws IOException {
    }

    public void registerAlias(String beanName, String alias) throws BeanDefinitionStoreException {
        throw new UnsupportedOperationException("ExternalBeanFactories don't support alises");
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
    }

    public void removeAlias(String aliasName) {
    }

    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (PathedBeanFactory)beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanSource(ExternalBeanSource beanSource) {
        this.beanSource = beanSource;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
        return null;
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        return Collections.emptyMap();
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        return Collections.emptyMap();
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.beanSource.getBean(requiredType);
    }
}

