/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionEvaluationUtils {
    public static final String EXPRESSION_CACHE_CONTEXT_PARAM = "cacheJspExpressions";
    public static final String EXPRESSION_PREFIX = "${";
    public static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_CACHE_FLAG_CONTEXT_ATTR = String.valueOf(ExpressionEvaluationUtils.class.getName()) + ".CACHE_JSP_EXPRESSIONS";
    private static final String EXPRESSION_CACHE_MAP_CONTEXT_ATTR = String.valueOf(ExpressionEvaluationUtils.class.getName()) + ".JSP_EXPRESSION_CACHE";

    public static boolean isExpressionLanguage(String value) {
        return value != null && value.contains(EXPRESSION_PREFIX);
    }

    public static Object evaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, resultClass, pageContext);
        }
        if (attrValue != null && resultClass != null && !resultClass.isInstance(attrValue)) {
            throw new JspException("Attribute value \"" + attrValue + "\" is neither a JSP EL expression nor " + "assignable to result class [" + resultClass.getName() + "]");
        }
        return attrValue;
    }

    public static Object evaluate(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Object.class, pageContext);
        }
        return attrValue;
    }

    public static String evaluateString(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (String)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, String.class, pageContext);
        }
        return attrValue;
    }

    public static int evaluateInteger(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Integer)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Integer.class, pageContext);
        }
        return Integer.parseInt(attrValue);
    }

    public static boolean evaluateBoolean(String attrName, String attrValue, PageContext pageContext) throws JspException {
        if (ExpressionEvaluationUtils.isExpressionLanguage(attrValue)) {
            return (Boolean)ExpressionEvaluationUtils.doEvaluate(attrName, attrValue, Boolean.class, pageContext);
        }
        return Boolean.valueOf(attrValue);
    }

    private static Object doEvaluate(String attrName, String attrValue, Class resultClass, PageContext pageContext) throws JspException {
        Assert.notNull((Object)attrValue, (String)"Attribute value must not be null");
        Assert.notNull((Object)resultClass, (String)"Result class must not be null");
        Assert.notNull((Object)pageContext, (String)"PageContext must not be null");
        try {
            if (resultClass.isAssignableFrom(String.class)) {
                StringBuilder resultValue = null;
                int exprPrefixIndex = -1;
                int exprSuffixIndex = 0;
                do {
                    if ((exprPrefixIndex = attrValue.indexOf(EXPRESSION_PREFIX, exprSuffixIndex)) != -1) {
                        int prevExprSuffixIndex = exprSuffixIndex;
                        exprSuffixIndex = attrValue.indexOf(EXPRESSION_SUFFIX, exprPrefixIndex + EXPRESSION_PREFIX.length());
                        String expr = null;
                        expr = exprSuffixIndex != -1 ? attrValue.substring(exprPrefixIndex, exprSuffixIndex += EXPRESSION_SUFFIX.length()) : attrValue.substring(exprPrefixIndex);
                        if (expr.length() == attrValue.length()) {
                            return ExpressionEvaluationUtils.evaluateExpression(attrValue, resultClass, pageContext);
                        }
                        if (resultValue == null) {
                            resultValue = new StringBuilder();
                        }
                        resultValue.append(attrValue.substring(prevExprSuffixIndex, exprPrefixIndex));
                        resultValue.append(ExpressionEvaluationUtils.evaluateExpression(expr, String.class, pageContext));
                        continue;
                    }
                    if (resultValue == null) {
                        resultValue = new StringBuilder();
                    }
                    resultValue.append(attrValue.substring(exprSuffixIndex));
                } while (exprPrefixIndex != -1 && exprSuffixIndex != -1);
                return resultValue.toString();
            }
            return ExpressionEvaluationUtils.evaluateExpression(attrValue, resultClass, pageContext);
        }
        catch (ELException ex) {
            throw new JspException("Parsing of JSP EL expression failed for attribute '" + attrName + "'", (Throwable)ex);
        }
    }

    private static Object evaluateExpression(String exprValue, Class resultClass, PageContext pageContext) throws ELException {
        Map<ExpressionCacheKey, Expression> expressionCache = ExpressionEvaluationUtils.getJspExpressionCache(pageContext);
        if (expressionCache != null) {
            ExpressionCacheKey cacheKey = new ExpressionCacheKey(exprValue, resultClass);
            Expression expr = expressionCache.get(cacheKey);
            if (expr == null) {
                expr = pageContext.getExpressionEvaluator().parseExpression(exprValue, resultClass, null);
                expressionCache.put(cacheKey, expr);
            }
            return expr.evaluate(pageContext.getVariableResolver());
        }
        return pageContext.getExpressionEvaluator().evaluate(exprValue, resultClass, pageContext.getVariableResolver(), null);
    }

    private static Map<ExpressionCacheKey, Expression> getJspExpressionCache(PageContext pageContext) {
        ServletContext servletContext = pageContext.getServletContext();
        Map cacheMap = (Map)servletContext.getAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR);
        if (cacheMap == null) {
            Boolean cacheFlag = (Boolean)servletContext.getAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR);
            if (cacheFlag == null) {
                cacheFlag = Boolean.valueOf(servletContext.getInitParameter(EXPRESSION_CACHE_CONTEXT_PARAM));
                servletContext.setAttribute(EXPRESSION_CACHE_FLAG_CONTEXT_ATTR, (Object)cacheFlag);
            }
            if (cacheFlag.booleanValue()) {
                cacheMap = Collections.synchronizedMap(new HashMap());
                servletContext.setAttribute(EXPRESSION_CACHE_MAP_CONTEXT_ATTR, cacheMap);
            }
        }
        return cacheMap;
    }

    private static class ExpressionCacheKey {
        private final String value;
        private final Class resultClass;
        private final int hashCode;

        public ExpressionCacheKey(String value, Class resultClass) {
            this.value = value;
            this.resultClass = resultClass;
            this.hashCode = this.value.hashCode() * 29 + this.resultClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionCacheKey)) {
                return false;
            }
            ExpressionCacheKey other = (ExpressionCacheKey)obj;
            return this.value.equals(other.value) && this.resultClass.equals(other.resultClass);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

