/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Iterator;
import org.springframework.util.Assert;
import org.springframework.util.CompositeIterator;
import org.springframework.util.StringKeyedMapAdapter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeWebRequestParameterMap
extends StringKeyedMapAdapter<Object> {
    private NativeWebRequest request;

    public NativeWebRequestParameterMap(NativeWebRequest request) {
        Assert.notNull((Object)request, (String)"The NativeWebRequest is required");
        this.request = request;
    }

    protected Object getAttribute(String key) {
        MultipartRequest multipartRequest;
        MultipartFile data;
        if (this.request instanceof MultipartRequest && (data = (multipartRequest = (MultipartRequest)((Object)this.request)).getFileMap().get(key)) != null) {
            return data;
        }
        String[] parameters = this.request.getParameterValues(key);
        if (parameters == null) {
            return null;
        }
        if (parameters.length == 1) {
            return parameters[0];
        }
        return parameters;
    }

    protected void setAttribute(String key, Object value) {
        throw new UnsupportedOperationException("WebRequest parameter maps are immutable");
    }

    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("WebRequest parameter maps are immutable");
    }

    protected Iterator<String> getAttributeNames() {
        if (this.request instanceof MultipartRequest) {
            MultipartRequest multipartRequest = (MultipartRequest)((Object)this.request);
            CompositeIterator iterator = new CompositeIterator();
            iterator.add(multipartRequest.getFileMap().keySet().iterator());
            iterator.add(this.request.getParameterNames());
            return iterator;
        }
        return this.request.getParameterNames();
    }
}

