/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingJacksonHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonEncoding encoding = JsonEncoding.UTF8;
    private boolean prefixJson = false;

    public MappingJacksonHttpMessageConverter() {
        super(new MediaType("application", "json"));
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
    }

    public void setEncoding(JsonEncoding encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        this.encoding = encoding;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.prefixJson = prefixJson;
    }

    @Override
    public boolean supports(Class<? extends T> clazz) {
        return this.objectMapper.canSerialize(clazz);
    }

    @Override
    protected T readInternal(Class<T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return (T)this.objectMapper.readValue(inputMessage.getBody(), clazz);
    }

    @Override
    protected MediaType getContentType(T t) {
        Charset charset = Charset.forName(this.encoding.getJavaName());
        return new MediaType("application", "json", charset);
    }

    @Override
    protected void writeInternal(T t, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonGenerator jsonGenerator = this.objectMapper.getJsonFactory().createJsonGenerator(outputMessage.getBody(), this.encoding);
        if (this.prefixJson) {
            jsonGenerator.writeRaw("{} && ");
        }
        this.objectMapper.writeValue(jsonGenerator, t);
    }
}

