/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedImageHttpMessageConverter
extends AbstractHttpMessageConverter<BufferedImage> {
    private MediaType contentType;
    private File cacheDir;

    public BufferedImageHttpMessageConverter() {
        String[] readerMediaTypes = ImageIO.getReaderMIMETypes();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>(readerMediaTypes.length);
        String[] stringArray = readerMediaTypes;
        int n = readerMediaTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String mediaType = stringArray[n2];
            supportedMediaTypes.add(MediaType.parseMediaType(mediaType));
            ++n2;
        }
        this.setSupportedMediaTypes(supportedMediaTypes);
        String[] writerMediaTypes = ImageIO.getWriterMIMETypes();
        if (writerMediaTypes.length > 0) {
            this.contentType = MediaType.parseMediaType(writerMediaTypes[0]);
        }
    }

    @Override
    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"'supportedMediaTypes' must not be empty");
        for (MediaType supportedMediaType : supportedMediaTypes) {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(supportedMediaType.toString());
            if (imageReaders.hasNext()) continue;
            throw new IllegalArgumentException("MediaType [" + supportedMediaType + "] is not supported by the Java Image I/O API");
        }
        super.setSupportedMediaTypes(supportedMediaTypes);
    }

    public void setContentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(contentType.toString());
        if (!imageWriters.hasNext()) {
            throw new IllegalArgumentException("ContentType [" + contentType + "] is not supported by the Java Image I/O API");
        }
        this.contentType = contentType;
    }

    public void setCacheDir(File cacheDir) {
        Assert.notNull((Object)cacheDir, (String)"'cacheDir' must not be null");
        Assert.isTrue((boolean)cacheDir.isDirectory(), (String)"'cacheDir' is not a directory");
        this.cacheDir = cacheDir;
    }

    @Override
    public boolean supports(Class<? extends BufferedImage> clazz) {
        return BufferedImage.class.equals(clazz);
    }

    @Override
    public BufferedImage readInternal(Class<BufferedImage> clazz, HttpInputMessage inputMessage) throws IOException {
        MediaType contentType;
        block10: {
            BufferedImage bufferedImage;
            block11: {
                ImageInputStream imageInputStream = null;
                ImageReader imageReader = null;
                try {
                    imageInputStream = this.createImageInputStream(inputMessage.getBody());
                    contentType = inputMessage.getHeaders().getContentType();
                    Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(contentType.toString());
                    if (!imageReaders.hasNext()) break block10;
                    imageReader = imageReaders.next();
                    ImageReadParam irp = imageReader.getDefaultReadParam();
                    this.process(irp);
                    imageReader.setInput(imageInputStream, true);
                    bufferedImage = imageReader.read(0, irp);
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (imageReader != null) {
                        imageReader.dispose();
                    }
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
            }
            return bufferedImage;
        }
        throw new HttpMessageNotReadableException("Could not find javax.imageio.ImageReader for Content-Type [" + contentType + "]");
    }

    private ImageInputStream createImageInputStream(InputStream is) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageInputStream(is, this.cacheDir);
        }
        return new MemoryCacheImageInputStream(is);
    }

    @Override
    protected MediaType getContentType(BufferedImage image) {
        return this.contentType;
    }

    @Override
    protected void writeInternal(BufferedImage image, HttpOutputMessage outputMessage) throws IOException {
        ImageOutputStream imageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            imageOutputStream = this.createImageOutputStream(outputMessage.getBody());
            Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(this.contentType.toString());
            if (!imageWriters.hasNext()) {
                throw new HttpMessageNotWritableException("Could not find javax.imageio.ImageWriter for Content-Type [" + this.contentType + "]");
            }
            imageWriter = imageWriters.next();
            ImageWriteParam iwp = imageWriter.getDefaultWriteParam();
            this.process(iwp);
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(image, null, null), iwp);
        }
        catch (Throwable throwable) {
            if (imageWriter != null) {
                imageWriter.dispose();
            }
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (imageWriter != null) {
            imageWriter.dispose();
        }
        if (imageOutputStream != null) {
            try {
                imageOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ImageOutputStream createImageOutputStream(OutputStream os) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageOutputStream(os, this.cacheDir);
        }
        return new MemoryCacheImageOutputStream(os);
    }

    protected void process(ImageReadParam irp) {
    }

    protected void process(ImageWriteParam iwp) {
    }
}

