/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Md5HashUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] getHash(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            return messageDigest.digest(bytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MD5 MessageDigest instance", ex);
        }
    }

    private static char[] getHashChars(byte[] bytes) {
        byte[] hash = Md5HashUtils.getHash(bytes);
        char[] chars = new char[32];
        int i = 0;
        while (i < chars.length) {
            byte b = hash[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
            i += 2;
        }
        return chars;
    }

    public static String getHashString(byte[] bytes) {
        return new String(Md5HashUtils.getHashChars(bytes));
    }

    public static StringBuilder appendHashString(byte[] bytes, StringBuilder builder) {
        builder.append(Md5HashUtils.getHashChars(bytes));
        return builder;
    }
}

