/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.NoOpConversionExecutor;

class ObjectToCollection
implements ConversionExecutor {
    private final TypeDescriptor targetCollectionType;
    private final ConversionExecutor elementConverter;

    public ObjectToCollection(TypeDescriptor sourceObjectType, TypeDescriptor targetCollectionType, GenericConversionService typeConverter) {
        this.targetCollectionType = targetCollectionType;
        Class<?> elementType = targetCollectionType.getElementType();
        this.elementConverter = elementType != null ? typeConverter.getConversionExecutor(sourceObjectType.getType(), TypeDescriptor.valueOf(elementType)) : NoOpConversionExecutor.INSTANCE;
    }

    public Object execute(Object source) throws ConversionFailedException {
        Collection collection = CollectionFactory.createCollection(this.targetCollectionType.getType(), 1);
        collection.add(this.elementConverter.execute(source));
        return collection;
    }
}

