/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;

class ObjectToArray
implements ConversionExecutor {
    private final TypeDescriptor targetArrayType;
    private final ConversionExecutor elementConverter;

    public ObjectToArray(TypeDescriptor sourceObjectType, TypeDescriptor targetArrayType, GenericConversionService conversionService) {
        this.targetArrayType = targetArrayType;
        this.elementConverter = conversionService.getConversionExecutor(sourceObjectType.getType(), TypeDescriptor.valueOf(targetArrayType.getElementType()));
    }

    public Object execute(Object source) throws ConversionFailedException {
        Object array = Array.newInstance(this.targetArrayType.getElementType(), 1);
        Object element = this.elementConverter.execute(source);
        Array.set(array, 0, element);
        return array;
    }
}

