/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

class MapToStringArray
implements ConversionExecutor {
    private final TypeDescriptor targetType;
    private final GenericConversionService conversionService;
    private final MapEntryConverter entryConverter;

    public MapToStringArray(TypeDescriptor targetType, GenericConversionService conversionService) {
        this.targetType = targetType;
        this.conversionService = conversionService;
        this.entryConverter = this.createEntryConverter();
    }

    private MapEntryConverter createEntryConverter() {
        if (this.targetType.isMapEntryTypeKnown()) {
            ConversionExecutor keyConverter = this.conversionService.getConversionExecutor(this.targetType.getMapKeyType(), TypeDescriptor.valueOf(String.class));
            ConversionExecutor valueConverter = this.conversionService.getConversionExecutor(this.targetType.getMapValueType(), TypeDescriptor.valueOf(String.class));
            return new MapEntryConverter(keyConverter, valueConverter);
        }
        return MapEntryConverter.NO_OP_INSTANCE;
    }

    public Object execute(Object source) throws ConversionFailedException {
        Map sourceMap = (Map)source;
        Object array = Array.newInstance(this.targetType.getElementType(), sourceMap.size());
        int i = 0;
        Iterator iterator = sourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry mapEntry = entry = iterator.next();
            Object key = mapEntry.getKey();
            Object value = mapEntry.getValue();
            String property = this.entryConverter.convertKey(key) + "=" + this.entryConverter.convertValue(value);
            Array.set(array, i, property);
            ++i;
        }
        return array;
    }
}

