/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Map;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConversionExecutor;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.MapEntryConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapToMap
implements ConversionExecutor {
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;
    private final GenericConversionService conversionService;
    private final MapEntryConverter entryConverter;

    public MapToMap(TypeDescriptor sourceType, TypeDescriptor targetType, GenericConversionService conversionService) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.conversionService = conversionService;
        this.entryConverter = this.createEntryConverter();
    }

    private MapEntryConverter createEntryConverter() {
        if (this.sourceType.isMapEntryTypeKnown() && this.targetType.isMapEntryTypeKnown()) {
            ConversionExecutor keyConverter = this.conversionService.getConversionExecutor(this.sourceType.getMapKeyType(), TypeDescriptor.valueOf(this.targetType.getMapKeyType()));
            ConversionExecutor valueConverter = this.conversionService.getConversionExecutor(this.sourceType.getMapValueType(), TypeDescriptor.valueOf(this.targetType.getMapValueType()));
            return new MapEntryConverter(keyConverter, valueConverter);
        }
        return MapEntryConverter.NO_OP_INSTANCE;
    }

    @Override
    public Object execute(Object source) throws ConversionFailedException {
        try {
            Map map = (Map)source;
            Map targetMap = CollectionFactory.createMap(this.targetType.getType(), map.size());
            MapEntryConverter converter = this.getEntryConverter(map);
            for (Map.Entry entry : map.entrySet()) {
                targetMap.put(converter.convertKey(entry.getKey()), converter.convertValue(entry.getValue()));
            }
            return targetMap;
        }
        catch (Exception ex) {
            throw new ConversionFailedException(source, this.sourceType.getType(), this.targetType.getType(), ex);
        }
    }

    private MapEntryConverter getEntryConverter(Map<?, ?> map) {
        MapEntryConverter entryConverter = this.entryConverter;
        if (entryConverter == MapEntryConverter.NO_OP_INSTANCE) {
            Class<?> targetKeyType = this.targetType.getMapKeyType();
            Class<?> targetValueType = this.targetType.getMapValueType();
            if (targetKeyType != null && targetValueType != null) {
                ConversionExecutor keyConverter = null;
                ConversionExecutor valueConverter = null;
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (keyConverter == null && key != null) {
                        keyConverter = this.conversionService.getConversionExecutor(key.getClass(), TypeDescriptor.valueOf(targetKeyType));
                    }
                    if (valueConverter == null && value != null) {
                        valueConverter = this.conversionService.getConversionExecutor(value.getClass(), TypeDescriptor.valueOf(targetValueType));
                    }
                    if (keyConverter != null && valueConverter != null) break;
                }
                entryConverter = new MapEntryConverter(keyConverter, valueConverter);
            }
        }
        return entryConverter;
    }
}

