/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDescriptor {
    public static final TypeDescriptor NULL = new TypeDescriptor(null);
    private Class<?> type;
    private MethodParameter methodParameter;
    private Field field;
    private Annotation[] cachedFieldAnnotations;

    public TypeDescriptor(Class<?> type) {
        this.type = type;
    }

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.field != null) {
            return this.field.getType();
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getParameterType();
        }
        return null;
    }

    public String getName() {
        Class<?> type = this.getType();
        if (type != null) {
            return this.getType().getName();
        }
        return null;
    }

    public boolean isArray() {
        Class<?> type = this.getType();
        return type != null && type.isArray();
    }

    public boolean isCollection() {
        return this.isTypeAssignableTo(Collection.class);
    }

    public Class<?> getElementType() {
        if (this.isArray()) {
            return this.getArrayComponentType();
        }
        if (this.isCollection()) {
            return this.getCollectionElementType();
        }
        return null;
    }

    public boolean isMap() {
        return this.isTypeAssignableTo(Map.class);
    }

    public boolean isMapEntryTypeKnown() {
        return this.isMap() && this.getMapKeyType() != null && this.getMapValueType() != null;
    }

    public Class<?> getMapKeyType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapKeyFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
        }
        return null;
    }

    public Class<?> getMapValueType() {
        if (this.field != null) {
            return GenericCollectionTypeResolver.getMapValueFieldType(this.field);
        }
        if (this.methodParameter != null) {
            return GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        if (this.field != null) {
            if (this.cachedFieldAnnotations == null) {
                this.cachedFieldAnnotations = this.field.getAnnotations();
            }
            return this.cachedFieldAnnotations;
        }
        if (this.methodParameter != null) {
            return this.methodParameter.getMethod().getAnnotations();
        }
        return new Annotation[0];
    }

    public boolean isAbstractClass() {
        Class<?> type = this.getType();
        return type != null && !this.getType().isInterface() && Modifier.isAbstract(this.getType().getModifiers());
    }

    public boolean isAssignableValue(Object obj) {
        Class<?> type = this.getType();
        return type != null && ClassUtils.isAssignableValue(this.getType(), obj);
    }

    public boolean isAssignableTo(TypeDescriptor targetType) {
        return ClassUtils.isAssignable(targetType.getType(), this.getType());
    }

    public String asString() {
        StringBuffer stringValue = new StringBuffer();
        if (this.isArray()) {
            stringValue.append(this.getArrayComponentType().getName()).append("[]");
        } else {
            Class<?> clazz = this.getType();
            if (clazz == null) {
                return "null";
            }
            stringValue.append(clazz.getName());
            if (this.isCollection()) {
                Class<?> collectionType = this.getCollectionElementType();
                if (collectionType != null) {
                    stringValue.append("<").append(collectionType.getName()).append(">");
                }
            } else if (this.isMap()) {
                Class<?> keyType = this.getMapKeyType();
                Class<?> valType = this.getMapValueType();
                if (keyType != null && valType != null) {
                    stringValue.append("<").append(keyType.getName()).append(",");
                    stringValue.append(valType).append(">");
                }
            }
        }
        return stringValue.toString();
    }

    private Class<?> getArrayComponentType() {
        return this.getType().getComponentType();
    }

    private Class<?> getCollectionElementType() {
        if (this.type != null) {
            return GenericCollectionTypeResolver.getCollectionType(this.type);
        }
        if (this.field != null) {
            return GenericCollectionTypeResolver.getCollectionFieldType(this.field);
        }
        return GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
    }

    private boolean isTypeAssignableTo(Class<?> clazz) {
        Class<?> type = this.getType();
        return type != null && ClassUtils.isAssignable(clazz, type);
    }

    public static TypeDescriptor valueOf(Class type) {
        return new TypeDescriptor(type);
    }

    public static TypeDescriptor forObject(Object object) {
        return object == null ? NULL : TypeDescriptor.valueOf(object.getClass());
    }
}

