/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionFailedException
extends ConversionException {
    private transient Object value;
    private Class<?> sourceType;
    private Class<?> targetType;

    public ConversionFailedException(Object value, Class<?> sourceType, Class<?> targetType, Throwable cause) {
        super(ConversionFailedException.buildDefaultMessage(value, sourceType, targetType, cause), cause);
        this.value = value;
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public ConversionFailedException(Object value, Class<?> sourceType, Class<?> targetType, String message) {
        super(message);
        this.value = value;
        this.sourceType = sourceType;
        this.targetType = targetType;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    private static String buildDefaultMessage(Object value, Class<?> sourceType, Class<?> targetType, Throwable cause) {
        return "Unable to convert value " + StylerUtils.style(value) + " from type '" + ClassUtils.getQualifiedName(sourceType) + "' to type '" + ClassUtils.getQualifiedName(targetType) + "'; reason = '" + cause.getMessage() + "'";
    }
}

