/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.extender.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.core.io.Resource;
import org.springframework.osgi.extender.support.internal.ConfigUtils;
import org.springframework.osgi.io.OsgiBundleResourcePatternResolver;
import org.springframework.util.StringUtils;

public class BundleConfiguration {
    public static final String BOX_SPRING_CONTEXT_HEADER = "BoxSpring-Context";
    private static final String[] DEFAULT_FILE_NAMES = new String[]{"applicationContext.xml", "osgi-context.xml"};
    private static final Log LOGGER = LogFactory.getLog(BundleConfiguration.class);
    private boolean boxSpringEnabledBundle = false;
    private String[] DEFAULT_ROOT_RESOURCES = new String[]{"classpath*:META-INF/spring/"};
    private final String[] fileNames;
    private boolean layeringEnabled = true;
    private boolean publishContextAsService = false;
    private final Resource[] rootResources;

    public BundleConfiguration(Bundle bundle) {
        OsgiBundleResourcePatternResolver resolver = new OsgiBundleResourcePatternResolver(bundle);
        Dictionary headers = bundle.getHeaders();
        this.boxSpringEnabledBundle = BundleConfiguration.getBoxSpringContextHeader(headers) != null;
        this.publishContextAsService = BundleConfiguration.getPublishContext(headers);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (int i = 0; i < this.DEFAULT_ROOT_RESOURCES.length; ++i) {
            Resource[] resourcesToAdd = BundleConfiguration.resolveResources(resolver, this.DEFAULT_ROOT_RESOURCES[i]);
            resources.addAll(Arrays.asList(resourcesToAdd));
        }
        this.rootResources = resources.toArray(new Resource[0]);
        this.fileNames = BundleConfiguration.getFileNames(headers);
    }

    public static boolean getCreateAsync(Dictionary headers) {
        String value = BundleConfiguration.getDirectiveValue(headers, "create-asynchronously");
        return value != null ? Boolean.valueOf(value) : true;
    }

    public static String[] getFileNames(Dictionary headers) {
        String[] ctxEntries;
        String header = BundleConfiguration.getBoxSpringContextHeader(headers);
        if (StringUtils.hasText((String)header) && ';' != header.charAt(0)) {
            String locations = StringUtils.tokenizeToStringArray((String)header, (String)";")[0];
            ctxEntries = StringUtils.tokenizeToStringArray((String)locations, (String)",");
            if (ctxEntries.length == 1 && (ctxEntries[0].equals("*") || ctxEntries[0].equals("true"))) {
                ctxEntries = DEFAULT_FILE_NAMES;
            }
        } else {
            ctxEntries = DEFAULT_FILE_NAMES;
        }
        return ctxEntries;
    }

    public static boolean getPublishContext(Dictionary headers) {
        String value = BundleConfiguration.getDirectiveValue(headers, "publish-context");
        return value != null ? Boolean.valueOf(value) : true;
    }

    public static long getTimeOut(Dictionary headers) {
        String value = BundleConfiguration.getDirectiveValue(headers, "timeout");
        if (value != null) {
            if ("none".equalsIgnoreCase(value)) {
                return -2L;
            }
            return Long.valueOf(value);
        }
        return 300L;
    }

    public static boolean getWaitForDependencies(Dictionary headers) {
        String value = BundleConfiguration.getDirectiveValue(headers, "wait-for-dependencies");
        return value != null ? Boolean.valueOf(value) : true;
    }

    private static String getBoxSpringContextHeader(Dictionary headers) {
        Object header = null;
        if (headers != null) {
            header = headers.get(BOX_SPRING_CONTEXT_HEADER);
        }
        return header != null ? header.toString().trim() : null;
    }

    private static String getDirectiveValue(Dictionary headers, String directiveName) {
        String directive;
        String header = BundleConfiguration.getBoxSpringContextHeader(headers);
        if (header != null && (directive = ConfigUtils.getDirectiveValue(header, directiveName)) != null) {
            return directive;
        }
        return null;
    }

    private static Resource[] resolveResources(OsgiBundleResourcePatternResolver resolver, String locationPattern) {
        try {
            return resolver.getResources(locationPattern);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Unable to resolve resources for path " + locationPattern), (Throwable)e);
            return new Resource[0];
        }
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public Resource[] getRootResources() {
        return this.rootResources;
    }

    public boolean isBoxSpringPoweredBundle() {
        return this.boxSpringEnabledBundle;
    }

    public boolean isLayeringEnabled() {
        return this.layeringEnabled;
    }

    public boolean isPublishContextAsService() {
        return this.publishContextAsService;
    }
}

