/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpAnd
extends Operator {
    public OpAnd(int pos, SpelNodeImpl ... operands) {
        super("and", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        boolean rightValue;
        boolean leftValue;
        try {
            leftValue = (Boolean)state.convertValue(this.getLeftOperand().getValueInternal(state), BOOLEAN_TYPE_DESCRIPTOR);
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(this.getLeftOperand().getStartPosition());
            throw ee;
        }
        if (!leftValue) {
            return BooleanTypedValue.forValue(false);
        }
        try {
            rightValue = (Boolean)state.convertValue(this.getRightOperand().getValueInternal(state), BOOLEAN_TYPE_DESCRIPTOR);
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(this.getRightOperand().getStartPosition());
            throw ee;
        }
        return BooleanTypedValue.forValue(rightValue);
    }
}

