/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.web;

import com.mtvnet.boxspring.jmx.ObjectNamePostfixProvidingDefaultPathedBeanFactory;
import com.mtvnet.boxspring.path.AbstractPathedXmlApplicationContext;
import com.mtvnet.boxspring.web.ServletContextAwareChildPostProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.ui.context.Theme;
import org.springframework.ui.context.ThemeSource;
import org.springframework.ui.context.support.UiApplicationContextUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.support.ServletContextAwareProcessor;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class PathedXmlWebApplicationContext
extends AbstractPathedXmlApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    public static final String DEFAULT_FILE_NAME = "applicationContext.xml";
    public static final String DEFAULT_FILE_NAME_PREFIX = "";
    public static final String DEFAULT_FILE_NAME_SUFFIX = ".xml";
    public static final String DEFAULT_RESOURCE_ROOT = "/WEB-INF/";
    public static final String FILE_NAME_PARAM = "contextConfigFileNames";
    private String[] fileNames;
    private String namespace;
    private Resource[] rootResources;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private ThemeSource themeSource;

    public PathedXmlWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    public String[] getConfigLocations() {
        Resource[] resources = this.getRootResources();
        String[] locations = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            try {
                locations[i] = resources[i].getURI().toString();
                continue;
            }
            catch (IOException e) {
                locations[i] = resources[i].toString();
            }
        }
        return locations;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    public void setConfigLocation(String location) {
        this.setConfigLocations(StringUtils.tokenizeToStringArray((String)location, (String)",; \t\n"));
    }

    public void setConfigLocations(String[] locations) {
        if (locations != null) {
            Assert.noNullElements((Object[])locations, (String)"Config locations must not be null");
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (int i = 0; i < locations.length; ++i) {
                Resource[] resourcesToAdd = this.resolveResources(locations[i]);
                resources.addAll(Arrays.asList(resourcesToAdd));
            }
            this.rootResources = resources.toArray(new Resource[0]);
        } else {
            this.rootResources = null;
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new ObjectNamePostfixProvidingDefaultPathedBeanFactory(this.getServletContext().getInitParameter("jmx.context.name"), this.getRootResources(), this.getFileNames(), this.createBeanDefinitionReaderFactory(), null, this.getInternalParentBeanFactory());
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    public void setServletConfig(ServletConfig servletConfig) {
        String fileNameParam;
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.servletContext = servletConfig.getServletContext();
        }
        this.fileNames = (fileNameParam = servletConfig.getInitParameter(FILE_NAME_PARAM)) != null ? StringUtils.tokenizeToStringArray((String)fileNameParam, (String)",; \t\n") : null;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
        String fileNameParam = servletContext.getInitParameter(FILE_NAME_PARAM);
        if (fileNameParam != null) {
            this.fileNames = StringUtils.tokenizeToStringArray((String)fileNameParam, (String)",; \t\n");
        }
    }

    protected String[] getDefaultFileNames() {
        if (this.getNamespace() != null) {
            return new String[]{DEFAULT_FILE_NAME_PREFIX + this.getNamespace() + DEFAULT_FILE_NAME_SUFFIX};
        }
        return new String[]{DEFAULT_FILE_NAME};
    }

    protected Resource[] getDefaultRootResources() {
        return new Resource[]{new ServletContextResource(this.getServletContext(), DEFAULT_RESOURCE_ROOT)};
    }

    protected String[] getFileNames() {
        return this.fileNames != null ? this.fileNames : this.getDefaultFileNames();
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver((ResourceLoader)this);
    }

    protected Resource[] getRootResources() {
        return this.rootResources != null ? this.rootResources : this.getDefaultRootResources();
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", (Scope)new RequestScope());
        beanFactory.registerScope("session", (Scope)new SessionScope(false));
        beanFactory.registerScope("globalSession", (Scope)new SessionScope(true));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareChildPostProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
    }

    protected Resource[] resolveResources(String path) {
        try {
            return this.getResources(SystemPropertyUtils.resolvePlaceholders((String)path));
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to resolve resources for path " + path), (Throwable)e);
            return new Resource[0];
        }
    }
}

