/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.web;

import com.mtvnet.boxspring.web.PathedXmlWebApplicationContext;
import com.mtvnet.boxspring.web.WebConstants;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathedContextLoaderListener
extends ContextLoaderListener {
    private static final Log logger = LogFactory.getLog(PathedContextLoaderListener.class);

    protected ContextLoader createContextLoader() {
        return new PathedContextLoader();
    }

    protected Class<? extends WebApplicationContext> getDefaultContextClass() {
        return PathedXmlWebApplicationContext.class;
    }

    private class PathedContextLoader
    extends ContextLoader {
        private PathedContextLoader() {
        }

        public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"There will be some errors in the logs now about missing placeholders. These are normal.");
            }
            return super.initWebApplicationContext(servletContext);
        }

        protected Class determineContextClass(ServletContext servletContext) throws ApplicationContextException {
            String contextClassName = servletContext.getInitParameter("contextClass");
            if (contextClassName != null) {
                try {
                    return ClassUtils.forName((String)contextClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)ex);
                }
            }
            return PathedContextLoaderListener.this.getDefaultContextClass();
        }

        protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
            if (servletContext.getInitParameter("contextConfigLocation") == null) {
                applicationContext.setConfigLocation(WebConstants.DEFAULT_CONFIG_LOCATIONS);
            }
            this.addAdditionalResourceRoots(servletContext, applicationContext);
        }

        private void addAdditionalResourceRoots(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
            String additionalConfigLocations = servletContext.getInitParameter("additionalContextConfigLocations");
            if (additionalConfigLocations != null) {
                Object[] existingConfigLocations = applicationContext.getConfigLocations();
                String updatedConfigLocations = StringUtils.arrayToCommaDelimitedString((Object[])existingConfigLocations) + "," + additionalConfigLocations;
                applicationContext.setConfigLocation(updatedConfigLocations);
            }
        }
    }
}

