/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.context.internal;

import com.mtvnet.boxspring.osgi.context.internal.ClassUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.util.OsgiFilterUtils;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

public abstract class TrackingUtil {
    public static Object getService(Class[] classes, String filter, ClassLoader classLoader, BundleContext context, Object fallbackObject) {
        String flt = OsgiFilterUtils.unifyFilter((Class[])classes, (String)filter);
        return Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)new OsgiServiceHandler(fallbackObject, context, ClassUtils.getParticularClass(classes).getName(), flt));
    }

    private static class OsgiServiceHandler
    implements InvocationHandler {
        private final Object fallbackObject;
        private final BundleContext context;
        private final String filterClassName;
        private final String filter;
        private final boolean securityOn;
        private final Object lock = new Object();
        private boolean bundleContextInvalidated = false;

        public OsgiServiceHandler(Object fallbackObject, BundleContext bundleContext, String filterClass, String filter) {
            this.fallbackObject = fallbackObject;
            this.context = bundleContext;
            this.filterClassName = filterClass;
            this.filter = filter;
            this.securityOn = System.getSecurityManager() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean isBundleInvalid;
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            Object target = null;
            Object object = this.lock;
            synchronized (object) {
                isBundleInvalid = this.bundleContextInvalidated;
            }
            if (!isBundleInvalid) {
                try {
                    target = this.securityOn ? AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return OsgiServiceHandler.this.getTarget(OsgiServiceHandler.this.context, OsgiServiceHandler.this.filter);
                        }
                    }) : this.getTarget(this.context, this.filter);
                }
                catch (IllegalStateException ise) {
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.bundleContextInvalidated = true;
                    }
                }
            }
            if (target == null) {
                target = this.fallbackObject;
            }
            try {
                Object result = method.invoke(target, args);
                return result;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private Object getTarget(BundleContext context, String filter) {
            ServiceReference ref = OsgiServiceReferenceUtils.getServiceReference((BundleContext)context, (String)this.filterClassName, (String)filter);
            return ref != null ? context.getService(ref) : null;
        }
    }
}

