/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractSimpleBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected final void doParse(Element element, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        int x = 0;
        while (x < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(x);
            if (this.isEligibleAttribute(attribute)) {
                String propertyName = this.extractPropertyName(attribute.getLocalName());
                Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
                builder.addPropertyValue(propertyName, attribute.getValue());
            }
            ++x;
        }
        this.postProcess(builder, element);
    }

    protected boolean isEligibleAttribute(Attr attribute) {
        String fullName = attribute.getName();
        return !fullName.equals("xmlns") && !fullName.startsWith("xmlns:") && this.isEligibleAttribute(attribute.getLocalName());
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"id".equals(attributeName);
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
    }
}

