/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public abstract class AbstractDetectingUrlHandlerMapping
extends AbstractUrlHandlerMapping {
    private boolean detectHandlersInAncestorContexts = false;

    public void setDetectHandlersInAncestorContexts(boolean detectHandlersInAncestorContexts) {
        this.detectHandlersInAncestorContexts = detectHandlersInAncestorContexts;
    }

    public void initApplicationContext() throws ApplicationContextException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for URL mappings in application context: " + this.getApplicationContext()));
        }
        String[] beanNames = this.detectHandlersInAncestorContexts ? BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), Object.class) : this.getApplicationContext().getBeanNamesForType(Object.class);
        int i = 0;
        while (i < beanNames.length) {
            String beanName = beanNames[i];
            Object[] urls = this.determineUrlsForHandler(beanName);
            if (!ObjectUtils.isEmpty((Object[])urls)) {
                this.registerHandler((String[])urls, beanName);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Rejected bean name '" + beanNames[i] + "': no URL paths identified"));
            }
            ++i;
        }
    }

    protected abstract String[] determineUrlsForHandler(String var1);
}

