/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.path;

import com.mtvnet.boxspring.path.BeanDefinitionReaderFactory;
import com.mtvnet.boxspring.path.BeanDefinitionValueResolver;
import com.mtvnet.boxspring.path.DefaultPathManager;
import com.mtvnet.boxspring.path.Path;
import com.mtvnet.boxspring.path.PathAwarePostProcessor;
import com.mtvnet.boxspring.path.PathManager;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import com.mtvnet.boxspring.path.ResourceBasedPathedBeanFactory;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPathedBeanFactory
extends DefaultListableBeanFactory
implements ResourceBasedPathedBeanFactory,
InitializingBean,
DisposableBean {
    private BeanDefinitionReader beanDefinitionReader;
    private BeanDefinitionReaderFactory beanDefinitionReaderFactory;
    private String beanName;
    private PathedBeanFactory containingBeanFactory;
    private String[] fileNames;
    private PathManager pathManager = new DefaultPathManager();
    private Resource[] rootResources;

    public DefaultPathedBeanFactory(Resource rootResource, String fileName, BeanDefinitionReaderFactory beanDefinitionReaderFactory) {
        this(rootResource, fileName, beanDefinitionReaderFactory, null);
    }

    public DefaultPathedBeanFactory(Resource rootResource, String fileName, BeanDefinitionReaderFactory beanDefinitionReaderFactory, PathedBeanFactory containingBeanFactory) {
        this(rootResource, fileName, beanDefinitionReaderFactory, containingBeanFactory, null);
    }

    public DefaultPathedBeanFactory(Resource rootResource, String fileName, BeanDefinitionReaderFactory beanDefinitionReaderFactory, PathedBeanFactory containingBeanFactory, BeanFactory parentBeanFactory) {
        this(new Resource[]{rootResource}, new String[]{fileName}, beanDefinitionReaderFactory, containingBeanFactory, parentBeanFactory);
    }

    public DefaultPathedBeanFactory(Resource[] rootResourcess, String[] fileNames, BeanDefinitionReaderFactory beanDefinitionReaderFactory) {
        this(rootResourcess, fileNames, beanDefinitionReaderFactory, null, null);
    }

    public DefaultPathedBeanFactory(Resource[] rootResources, String[] fileNames, BeanDefinitionReaderFactory beanDefinitionReaderFactory, PathedBeanFactory containingBeanFactory, BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
        this.rootResources = rootResources;
        this.fileNames = fileNames;
        this.beanDefinitionReaderFactory = beanDefinitionReaderFactory;
        this.beanDefinitionReader = beanDefinitionReaderFactory.createReader(this);
        this.containingBeanFactory = containingBeanFactory;
        this.copyConfiguration();
        this.addBeanPostProcessor(new PathAwarePostProcessor(this, this.pathManager));
    }

    public void afterPropertiesSet() throws Exception {
        this.loadBeanDefinitions();
    }

    public boolean containsBean(String name) {
        if (this.pathManager.isPath(name)) {
            Path path = this.pathManager.parsePath(name);
            return this.containsBean(path);
        }
        return super.containsBean(name);
    }

    public void destroy() throws Exception {
        this.destroySingletons();
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null, null);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return this.getBean(name, requiredType, null);
    }

    public Object getBean(String name, Object ... args) throws BeansException {
        return this.getBean(name, null, args);
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType, Object[] args) throws BeansException {
        if (this.pathManager.isPath(name)) {
            Path path = this.pathManager.parsePath(name);
            return this.getBean(path, requiredType, args);
        }
        if (name.equals(".")) {
            return (T)this;
        }
        return (T)super.getBean(name, requiredType, args);
    }

    public BeanDefinition getBeanDefinition(String name) {
        if (this.pathManager.isPath(name)) {
            Path path = this.pathManager.parsePath(name);
            return this.getBeanDefinition(path);
        }
        return super.getBeanDefinition(name);
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public PathedBeanFactory getContainingBeanFactory() {
        return this.containingBeanFactory;
    }

    @Override
    public String[] getFileNames() {
        return this.fileNames;
    }

    @Override
    public Resource[] getRootResources() {
        return this.rootResources;
    }

    @Override
    public boolean isPathRootBeanFactory() {
        return this.containingBeanFactory == null;
    }

    @Override
    public void loadBeanDefinitions() throws IOException {
        for (Resource rootResource : this.rootResources) {
            for (String fileName : this.fileNames) {
                try {
                    Resource resource = rootResource.createRelative(fileName);
                    this.beanDefinitionReader.loadBeanDefinitions(resource);
                }
                catch (BeanDefinitionStoreException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                        this.logger.debug((Object)("Can't find file to load bean defintions named " + fileName + " under " + rootResource.toString()));
                        continue;
                    }
                    this.logger.warn((Object)("Unable to load bean defintions from " + fileName + " under " + rootResource.toString() + " due to " + ((Object)((Object)e)).getClass().getName() + " : " + e.getMessage()));
                }
            }
        }
    }

    public void preInstantiateSingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in " + this));
        }
        String[] beanDefinitionNames = this.getBeanDefinitionNames();
        for (int i = 0; i < beanDefinitionNames.length; ++i) {
            String beanName = beanDefinitionNames[i];
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            if (this.isFactoryBean(beanName)) {
                FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                if (!(factory instanceof SmartFactoryBean) || !((SmartFactoryBean)factory).isEagerInit()) continue;
                this.getBean(beanName);
                continue;
            }
            this.getBean(beanName);
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected void applyPropertyValues(String beanName, BeanDefinition mbd, BeanWrapper bw, PropertyValues pvs) {
        if (pvs == null || pvs.isEmpty()) {
            return;
        }
        MutablePropertyValues mpvs = null;
        List original = null;
        if (pvs instanceof MutablePropertyValues) {
            mpvs = (MutablePropertyValues)pvs;
            if (mpvs.isConverted()) {
                try {
                    bw.setPropertyValues((PropertyValues)mpvs);
                    return;
                }
                catch (BeansException ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", (Throwable)ex);
                }
            }
            original = mpvs.getPropertyValueList();
        } else {
            original = Arrays.asList(pvs.getPropertyValues());
        }
        TypeConverter converter = this.getCustomTypeConverter();
        if (converter == null) {
            converter = bw;
        }
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this, beanName, mbd, converter);
        ArrayList<PropertyValue> deepCopy = new ArrayList<PropertyValue>(original.size());
        boolean resolveNecessary = false;
        for (PropertyValue pv : original) {
            try {
                if (pv.isConverted()) {
                    deepCopy.add(pv);
                    continue;
                }
                String propertyName = pv.getName();
                Object originalValue = pv.getValue();
                Object resolvedValue = valueResolver.resolveValueIfNecessary(pv, originalValue);
                if (resolvedValue == originalValue) {
                    if (!PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
                        pv.setConvertedValue(this.convertForProperty(resolvedValue, propertyName, bw, converter));
                    }
                    deepCopy.add(pv);
                    continue;
                }
                if (originalValue instanceof TypedStringValue && !PropertyAccessorUtils.isNestedOrIndexedProperty((String)propertyName)) {
                    pv.setConvertedValue(this.convertForProperty(resolvedValue, propertyName, bw, converter));
                    deepCopy.add(pv);
                    continue;
                }
                resolveNecessary = true;
                deepCopy.add(new PropertyValue(pv, resolvedValue));
            }
            catch (InvalidPropertyException e) {
                this.logger.trace((Object)("Swallowing Invalid Property Exception for " + pv.getName()));
            }
        }
        if (mpvs != null && !resolveNecessary) {
            mpvs.setConverted();
        }
        try {
            bw.setPropertyValues((PropertyValues)new MutablePropertyValues(deepCopy), true, true);
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", (Throwable)ex);
        }
    }

    protected boolean containsBean(Path path) {
        return this.doWithPath(path, new BeanFactoryOperation<Boolean>(){

            @Override
            public Boolean getFromFactory(BeanFactory beanFactory, String beanName) {
                return ((DefaultListableBeanFactory)beanFactory).containsBean(beanName);
            }

            @Override
            public Boolean getFromSuper(String beanName) {
                return DefaultPathedBeanFactory.super.containsBean(beanName);
            }
        });
    }

    protected Object createBean(String beanName, RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        return super.createBean(beanName, mbd, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doWithPath(Path path, BeanFactoryOperation<T> op) {
        if (path.isAbsolute() && this.containingBeanFactory != null) {
            return op.getFromFactory((BeanFactory)this.containingBeanFactory, path.getOriginalName());
        }
        if (this.containsBeanDefinition(path.getOriginalName())) {
            return op.getFromSuper(path.getOriginalName());
        }
        String localPart = path.getLocalPart();
        if (path.hasChildPart()) {
            String childPart = path.getChildPart();
            PathedBeanFactory childFactory = null;
            if (localPart.equals("..")) {
                if (this.containingBeanFactory == null) {
                    throw new RuntimeException("bad bean path reference: " + path.getOriginalName());
                }
                return op.getFromFactory((BeanFactory)this.containingBeanFactory, childPart);
            }
            Object object = this.getSingletonMutex();
            synchronized (object) {
                childFactory = this.containsBeanDefinition(localPart) ? this.getBean(localPart, PathedBeanFactory.class) : this.createChildBeanFactory(path);
            }
            if (childPart.equals("")) {
                return op.getFromFactory((BeanFactory)this, localPart);
            }
            return op.getFromFactory((BeanFactory)childFactory, childPart);
        }
        return op.getFromSuper(localPart);
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class requiredType, DependencyDescriptor descriptor) {
        Map<String, Object> candidates = super.findAutowireCandidates(beanName, requiredType, descriptor);
        if (candidates.isEmpty()) {
            String candidatePath = "/" + requiredType.getName().replace(".", "/");
            try {
                Object bean = this.getBean(candidatePath);
                candidates = Collections.singletonMap(candidatePath, bean);
            }
            catch (BeansException e) {
                // empty catch block
            }
            if (candidates.isEmpty()) {
                String localPart = StringUtils.substringAfterLast((String)candidatePath, (String)"/");
                localPart = localPart.substring(0, 1).toLowerCase() + localPart.substring(1);
                candidatePath = StringUtils.substringBeforeLast((String)candidatePath, (String)"/") + "/" + localPart;
                try {
                    Object bean = this.getBean(candidatePath);
                    candidates = Collections.singletonMap(candidatePath, bean);
                }
                catch (BeansException e) {
                    // empty catch block
                }
            }
        }
        return candidates;
    }

    protected <T> T getBean(Path path, final Class<T> requiredType, final Object[] args) {
        return this.doWithPath(path, new BeanFactoryOperation<T>(){

            @Override
            public T getFromFactory(BeanFactory beanFactory, String beanName) {
                return ((PathedBeanFactory)beanFactory).getBean(beanName, requiredType, args);
            }

            @Override
            public T getFromSuper(String beanName) {
                return DefaultPathedBeanFactory.super.getBean(beanName, requiredType, args);
            }
        });
    }

    protected BeanDefinition getBeanDefinition(Path path) {
        return this.doWithPath(path, new BeanFactoryOperation<BeanDefinition>(){

            @Override
            public BeanDefinition getFromFactory(BeanFactory beanFactory, String beanName) {
                return ((PathedBeanFactory)beanFactory).getBeanDefinition(beanName);
            }

            @Override
            public BeanDefinition getFromSuper(String beanName) {
                return DefaultPathedBeanFactory.super.getBeanDefinition(beanName);
            }
        });
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd, BeanDefinition containingBd) throws BeanDefinitionStoreException {
        return super.getMergedBeanDefinition(beanName, bd, containingBd);
    }

    protected Object getObjectFromFactoryBean(FactoryBean factory, String beanName, boolean shouldPostProcess) {
        return super.getObjectFromFactoryBean(factory, beanName, shouldPostProcess);
    }

    private Object convertForProperty(Object value, String propertyName, BeanWrapper bw, TypeConverter converter) {
        if (converter instanceof BeanWrapperImpl) {
            return ((BeanWrapperImpl)converter).convertForProperty(value, propertyName);
        }
        PropertyDescriptor descriptor = bw.getPropertyDescriptor(propertyName);
        return converter.convertIfNecessary(value, descriptor.getPropertyType(), new MethodParameter(descriptor.getWriteMethod(), 0));
    }

    private void copyConfiguration() {
        if (this.containingBeanFactory != null && this.containingBeanFactory instanceof ConfigurableBeanFactory) {
            String[] scopeNames;
            ConfigurableBeanFactory containingConfigurableBeanFactory = (ConfigurableBeanFactory)this.containingBeanFactory;
            for (String scopeName : scopeNames = containingConfigurableBeanFactory.getRegisteredScopeNames()) {
                this.registerScope(scopeName, containingConfigurableBeanFactory.getRegisteredScope(scopeName));
            }
            this.setBeanClassLoader(containingConfigurableBeanFactory.getBeanClassLoader());
            this.setCacheBeanMetadata(containingConfigurableBeanFactory.isCacheBeanMetadata());
            if (this.containingBeanFactory instanceof AbstractBeanFactory) {
                AbstractBeanFactory otherAbstractFactory = (AbstractBeanFactory)this.containingBeanFactory;
                for (Class key : otherAbstractFactory.getCustomEditors().keySet()) {
                    Class value = (Class)otherAbstractFactory.getCustomEditors().get(key);
                    this.registerCustomEditor(key, value);
                }
                for (PropertyEditorRegistrar value : otherAbstractFactory.getPropertyEditorRegistrars()) {
                    this.addPropertyEditorRegistrar(value);
                }
            }
        }
    }

    private PathedBeanFactory createChildBeanFactory(Path path) {
        String localPart = path.getLocalPart();
        BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultPathedBeanFactory.class);
        try {
            Resource[] childResources = new Resource[this.rootResources.length];
            for (int i = 0; i < this.rootResources.length; ++i) {
                childResources[i] = path.createRelative(this.rootResources[i]);
            }
            defBuilder.addConstructorArgValue((Object)childResources);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        defBuilder.addConstructorArgValue((Object)this.fileNames);
        defBuilder.addConstructorArgValue((Object)this.beanDefinitionReaderFactory);
        defBuilder.addConstructorArgValue((Object)this);
        defBuilder.addConstructorArgValue((Object)this.getParentBeanFactoryFromContainingFactory(localPart));
        this.registerBeanDefinition(localPart, (BeanDefinition)defBuilder.getBeanDefinition());
        DefaultPathedBeanFactory childFactory = (DefaultPathedBeanFactory)this.getBean(localPart, PathedBeanFactory.class);
        return childFactory;
    }

    private PathedBeanFactory getParentBeanFactoryFromContainingFactory(String localPart) {
        if (this.getParentBeanFactory() instanceof PathedBeanFactory) {
            return (PathedBeanFactory)((PathedBeanFactory)this.getParentBeanFactory()).getBean(localPart + "/", PathedBeanFactory.class);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface BeanFactoryOperation<T> {
        public T getFromFactory(BeanFactory var1, String var2);

        public T getFromSuper(String var1);
    }
}

