/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.layers;

import com.mtvnet.boxspring.layers.CollectionOpUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class LayeredBeanUtils {
    public static void applyBeanDefinition(BeanDefinition newDefinition, String beanName, BeanDefinitionRegistry registry, boolean overwriteExistingProperties) {
        LayeredBeanUtils.applyBeanDefinition(newDefinition, beanName, registry, overwriteExistingProperties, null);
    }

    public static void applyBeanDefinition(BeanDefinition newDefinition, String beanName, BeanDefinitionRegistry registry, boolean overwriteExistingProperties, String comment) {
        BeanDefinition existingDefinition = registry.getBeanDefinition(beanName);
        LayeredBeanUtils.copyClass(newDefinition, existingDefinition);
        LayeredBeanUtils.copyProperties(newDefinition, existingDefinition, overwriteExistingProperties);
        LayeredBeanUtils.copyConstructorArguments(newDefinition, existingDefinition);
        if (existingDefinition instanceof AbstractBeanDefinition) {
            LayeredBeanUtils.copyForAbstractBeanDefinition(newDefinition, (AbstractBeanDefinition)existingDefinition, comment);
        }
    }

    private static void copyConstructorArguments(BeanDefinition newDefinition, BeanDefinition existingDefinition) {
        if (!newDefinition.getConstructorArgumentValues().isEmpty()) {
            existingDefinition.getConstructorArgumentValues().clear();
            existingDefinition.getConstructorArgumentValues().addArgumentValues(newDefinition.getConstructorArgumentValues());
        }
    }

    private static void copyClass(BeanDefinition newDefinition, BeanDefinition existingDefinition) {
        if (StringUtils.isNotBlank((String)newDefinition.getBeanClassName())) {
            existingDefinition.setBeanClassName(newDefinition.getBeanClassName());
            existingDefinition.getConstructorArgumentValues().clear();
            if (newDefinition instanceof AbstractBeanDefinition && existingDefinition instanceof AbstractBeanDefinition) {
                ((AbstractBeanDefinition)existingDefinition).setInitMethodName(((AbstractBeanDefinition)newDefinition).getInitMethodName());
                ((AbstractBeanDefinition)existingDefinition).setDestroyMethodName(((AbstractBeanDefinition)newDefinition).getDestroyMethodName());
            }
        }
    }

    private static void copyForAbstractBeanDefinition(BeanDefinition newDefinition, AbstractBeanDefinition existingDefinition, String comment) {
        StringBuilder newDescription = new StringBuilder();
        newDescription.append(existingDefinition.getResourceDescription()).append(", ").append(newDefinition.getResourceDescription());
        if (comment != null) {
            newDescription.append(" [").append(comment).append("]");
        }
        existingDefinition.setResourceDescription(newDescription.toString());
        if (newDefinition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition newAbd = (AbstractBeanDefinition)newDefinition;
            if (newAbd.getInitMethodName() != null) {
                existingDefinition.setInitMethodName(newAbd.getInitMethodName());
            }
            if (newAbd.getDestroyMethodName() != null) {
                existingDefinition.setDestroyMethodName(newAbd.getDestroyMethodName());
            }
        }
    }

    private static void copyProperties(BeanDefinition newDefinition, BeanDefinition existingDefinition, boolean overwriteExistingProperties) {
        MutablePropertyValues existingProperties = existingDefinition.getPropertyValues();
        for (PropertyValue prop : newDefinition.getPropertyValues().getPropertyValues()) {
            if (CollectionOpUtils.hasOp(prop)) {
                CollectionOpUtils.processOp(prop, existingProperties);
                continue;
            }
            if (overwriteExistingProperties) {
                if (existingProperties.contains(prop.getName())) {
                    existingProperties.removePropertyValue(prop.getName());
                }
                existingProperties.addPropertyValue(prop);
                continue;
            }
            if (existingProperties.contains(prop.getName())) continue;
            existingProperties.addPropertyValue(prop);
        }
    }
}

