/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.jmx;

import com.mtvnet.boxspring.jmx.ListableBeanFactoryDynamicMBean;
import com.mtvnet.boxspring.path.ChildPathedBeanFactoryPostProcessor;
import com.mtvnet.boxspring.path.PathedBeanFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.jmx.export.MBeanExporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathedDynamicMBeanPostProcessor
extends ChildPathedBeanFactoryPostProcessor
implements PriorityOrdered {
    private static final Log LOG = LogFactory.getLog(PathedDynamicMBeanPostProcessor.class);
    private static final char MBEAN_NAME_REPLACEMENT = '_';
    private static final List<Character> MBEAN_NAME_REPLACEMENTS = Arrays.asList(Character.valueOf(':'));
    private String basename;
    private MBeanExporter exporter;

    public PathedDynamicMBeanPostProcessor(MBeanExporter exporter, String basename) {
        this.exporter = exporter;
        this.basename = basename;
    }

    private static String cleanFactoryName(String factoryName) {
        for (char toReplace : MBEAN_NAME_REPLACEMENTS) {
            factoryName = factoryName.replace(toReplace, '_');
        }
        return factoryName;
    }

    private static List<String> generatePathComponents(PathedBeanFactory beanFactory) {
        if (beanFactory.getContainingBeanFactory() != null) {
            List<String> list = PathedDynamicMBeanPostProcessor.generatePathComponents(beanFactory.getContainingBeanFactory());
            String factoryName = beanFactory.getBeanName();
            factoryName = PathedDynamicMBeanPostProcessor.cleanFactoryName(factoryName);
            list.add(factoryName);
            return list;
        }
        return new ArrayList<String>();
    }

    public int getOrder() {
        return 1;
    }

    @Override
    protected Object postProcessChildBeanFactory(PathedBeanFactory beanFactory, String beanName) {
        List<String> fullPath = PathedDynamicMBeanPostProcessor.generatePathComponents(beanFactory);
        LOG.debug((Object)("fullPath = " + fullPath));
        StringBuffer mBeanBuffer = new StringBuffer(this.basename);
        for (int i = 0; i < fullPath.size(); ++i) {
            mBeanBuffer.append(",level").append(i + 1).append("=").append(fullPath.get(i));
        }
        String mBeanName = mBeanBuffer.toString();
        LOG.debug((Object)("produced name = " + mBeanName));
        RootBeanDefinition beanDef = new RootBeanDefinition(ListableBeanFactoryDynamicMBean.class);
        beanFactory.registerBeanDefinition(mBeanName, (BeanDefinition)beanDef);
        try {
            this.exporter.registerManagedResource(beanFactory.getBean(mBeanName), new ObjectName(mBeanName));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn((Object)("Unable to construct object name for bean named " + beanName), (Throwable)e);
        }
        return beanFactory;
    }
}

