/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.commons.beanutils.MethodUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ListableBeanFactoryDynamicMBean
implements DynamicMBean,
BeanFactoryAware {
    private static final String ATTR_NAME_BEAN_DEFINITION_COUNT = "beanDefinitionCount";
    private static final String ATTR_NAME_BEAN_DEFINITION_NAMES = "beanDefinitionNames";
    private static final String OP_NAME_GET_BEAN_DEFINITION = "getBeanDefinition";
    private ListableBeanFactory beanFactory;
    private MBeanInfo mbeanInfo;

    private static String formatBeanDefinition(BeanDefinition beanDef) {
        MutablePropertyValues values;
        StringBuffer formattedDef = new StringBuffer();
        String output = beanDef.toString();
        formattedDef.append(output.replace(';', '\n'));
        ConstructorArgumentValues constValues = beanDef.getConstructorArgumentValues();
        if (constValues.getArgumentCount() > 0) {
            formattedDef.append(" Constructor Values:\n");
            Map indexedArgs = constValues.getIndexedArgumentValues();
            for (Integer index : indexedArgs.keySet()) {
                ConstructorArgumentValues.ValueHolder value = (ConstructorArgumentValues.ValueHolder)indexedArgs.get(index);
                formattedDef.append("\n ").append(index).append(" - ").append(value.getValue().toString());
            }
            List genericArgs = constValues.getGenericArgumentValues();
            for (ConstructorArgumentValues.ValueHolder value : genericArgs) {
                formattedDef.append("\n ").append(value.getValue().toString());
            }
        }
        if (!(values = beanDef.getPropertyValues()).isEmpty()) {
            for (PropertyValue value : values.getPropertyValues()) {
                formattedDef.append("\n ").append(value.getName()).append(" - ").append(value.getValue().toString());
            }
        }
        return formattedDef.toString();
    }

    private static BeanDefinition getBeanDefinition(ListableBeanFactory beanFactory, String beanName) throws ReflectionException {
        ObjectMethodPair omp = ListableBeanFactoryDynamicMBean.getBeanDefinitionClassMethodPair(beanFactory);
        if (omp != null) {
            try {
                return (BeanDefinition)omp.invoke(new Object[]{beanName});
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }
        return null;
    }

    private static ObjectMethodPair getBeanDefinitionClassMethodPair(Object beanFactory) {
        Class<?> beanFactoryClass = beanFactory.getClass();
        Method beanDefinitionMethod = MethodUtils.getAccessibleMethod(beanFactoryClass, (String)OP_NAME_GET_BEAN_DEFINITION, String.class);
        if (beanDefinitionMethod != null) {
            return new ObjectMethodPair(beanFactory, beanDefinitionMethod);
        }
        if (beanFactory instanceof ConfigurableApplicationContext) {
            return ListableBeanFactoryDynamicMBean.getBeanDefinitionClassMethodPair(((ConfigurableApplicationContext)beanFactory).getBeanFactory());
        }
        return null;
    }

    private static boolean supportsGetBeanDefinition(Object beanFactory) {
        return ListableBeanFactoryDynamicMBean.getBeanDefinitionClassMethodPair(beanFactory) != null;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        Object retval = this.getAttributeValue(attribute);
        if (retval != null) {
            return retval;
        }
        throw new AttributeNotFoundException(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String attributeName = attributes[i];
            Object attributeValue = this.getAttributeValue(attributeName);
            if (attributeValue == null) continue;
            attributeList.add(new Attribute(attributeName, attributeValue));
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws ReflectionException {
        if (OP_NAME_GET_BEAN_DEFINITION.equals(actionName)) {
            BeanDefinition beanDef = ListableBeanFactoryDynamicMBean.getBeanDefinition(this.beanFactory, (String)params[0]);
            return beanDef == null ? null : ListableBeanFactoryDynamicMBean.formatBeanDefinition(beanDef);
        }
        return null;
    }

    public void setAttribute(Attribute attribute) {
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public void setBeanFactory(BeanFactory bf) {
        if (bf instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)bf;
        }
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        attrs.add(new MBeanAttributeInfo(ATTR_NAME_BEAN_DEFINITION_NAMES, List.class.getName(), "List of bean definition names", true, false, false));
        attrs.add(new MBeanAttributeInfo(ATTR_NAME_BEAN_DEFINITION_COUNT, Integer.class.getName(), "Count of bean definitions", true, false, false));
        ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
        if (ListableBeanFactoryDynamicMBean.supportsGetBeanDefinition(this.beanFactory)) {
            ops.add(new MBeanOperationInfo(OP_NAME_GET_BEAN_DEFINITION, "Outputs BeanDefinition Text", new MBeanParameterInfo[]{new MBeanParameterInfo("beanName", String.class.getName(), "The name of the bean")}, String.class.getName(), 0));
        }
        this.mbeanInfo = new MBeanInfo(ApplicationContext.class.getName(), "Spring Bean Factory", attrs.toArray(new MBeanAttributeInfo[0]), null, ops.toArray(new MBeanOperationInfo[0]), null);
    }

    private Object getAttributeValue(String attribute) {
        if (ATTR_NAME_BEAN_DEFINITION_NAMES.equals(attribute)) {
            return Arrays.asList(this.beanFactory.getBeanDefinitionNames());
        }
        if (ATTR_NAME_BEAN_DEFINITION_COUNT.equals(attribute)) {
            return this.beanFactory.getBeanDefinitionCount();
        }
        return null;
    }

    private static final class ObjectMethodPair {
        private Method method;
        private Object object;

        private ObjectMethodPair(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        private Object invoke(Object ... args) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(this.object, args);
        }
    }
}

