/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.factory;

import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDynamicObjectFactoryBean<C, T>
implements FactoryBean<C>,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private String contextPath;
    private Class<T> valueClass;

    public String getContextPath() {
        return this.contextPath;
    }

    public C getObject() throws Exception {
        String realContextPath = this.getRealContextPath();
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory.getBean(realContextPath, ListableBeanFactory.class);
        if (listableBeanFactory == null) {
            throw new BeanCreationException("Could not find bean factory for context path: " + this.contextPath);
        }
        return this.createDynamicCollection(listableBeanFactory);
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setValueClass(Class<T> clazz) {
        this.valueClass = clazz;
    }

    protected abstract C createDynamicCollection(ListableBeanFactory var1);

    protected Map<String, T> getBeansMap(ListableBeanFactory beanFactory) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, this.valueClass);
    }

    private String getRealContextPath() {
        String realContextPath = this.contextPath.endsWith("/.") ? this.contextPath : (this.contextPath.endsWith("/") ? this.contextPath + "." : this.contextPath + "/" + ".");
        return realContextPath;
    }
}

