/*
 * Decompiled with CFR 0.152.
 */
package com.mtvnet.boxspring.osgi.web.extender.internal;

import com.mtvnet.boxspring.osgi.web.extender.internal.HttpServiceWarDeploymentContext;
import com.mtvnet.boxspring.osgi.web.extender.internal.ServletContextBootstrapServlet;
import com.mtvnet.boxspring.osgi.web.support.LayeredPathedOsgiBundleContextLoaderServlet;
import com.mtvnet.boxspring.osgi.web.support.LayeredPathedOsgiBundleDispatcherServlet;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.deployer.WarDeploymentContext;

public class HttpServiceWarDeployment
implements WarDeployment {
    private static final Log logger = LogFactory.getLog(HttpServiceWarDeployment.class);
    private boolean active = false;
    private final ServletContextBootstrapServlet bootstrapServlet;
    private final HttpServiceWarDeploymentContext deploymentContext;
    private final HttpContext httpContext;
    private HttpService undeployHttpService;
    private final Map<String, Servlet> servlets = new LinkedHashMap<String, Servlet>();
    private final Map<String, String> resources = new LinkedHashMap<String, String>();

    public HttpServiceWarDeployment(Bundle bundle, String contextPath, HttpContext httpContext) {
        this.httpContext = httpContext;
        String normalizedContextPath = this.normalizeContextPath(contextPath);
        this.bootstrapServlet = new ServletContextBootstrapServlet(bundle);
        this.servlets.put(normalizedContextPath + "_INTERNAL_BOXSPRING_OSGI/boostrap/servlet_context", (Servlet)this.bootstrapServlet);
        this.deploymentContext = new HttpServiceWarDeploymentContext(bundle, contextPath, this.bootstrapServlet);
        LayeredPathedOsgiBundleContextLoaderServlet loaderServlet = new LayeredPathedOsgiBundleContextLoaderServlet();
        this.servlets.put(normalizedContextPath + "_INTERNAL_BOXSPRING_OSGI/boostrap/application_context", (Servlet)loaderServlet);
        LayeredPathedOsgiBundleDispatcherServlet dispatcherServlet = new LayeredPathedOsgiBundleDispatcherServlet();
        dispatcherServlet.setNamespace("dispatcher-servlet");
        this.servlets.put(contextPath, (Servlet)dispatcherServlet);
        this.findResources(normalizedContextPath, bundle);
    }

    private void findResources(String normalizedContextPath, Bundle bundle) {
        Enumeration e = bundle.findEntries("/", null, true);
        while (e.hasMoreElements()) {
            String alias;
            URL url = (URL)e.nextElement();
            String path = url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.startsWith("WEB-INF") || path.startsWith("META-INF") || (alias = normalizedContextPath + path).endsWith("/")) continue;
            this.resources.put(alias, path);
        }
    }

    private String normalizeContextPath(String contextPath) {
        if (!contextPath.endsWith("/")) {
            return contextPath + "/";
        }
        return contextPath;
    }

    public WarDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void start(HttpService deployHttpService, HttpService undeployHttpService) throws Exception {
        if (!this.active) {
            this.undeployHttpService = undeployHttpService;
            try {
                for (Map.Entry<String, String> entry : this.resources.entrySet()) {
                    deployHttpService.registerResources(entry.getKey(), entry.getValue(), this.httpContext);
                }
                for (Map.Entry<String, String> entry : this.servlets.entrySet()) {
                    deployHttpService.registerServlet(entry.getKey(), (Servlet)entry.getValue(), null, this.httpContext);
                }
            }
            catch (Exception e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)"Exception occurred during resource and servlet registration. Undeploying...");
                }
                try {
                    this.performUndeploy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            this.active = true;
            this.publishService();
        }
    }

    public synchronized void undeploy() throws OsgiWarDeploymentException {
        if (this.active) {
            this.performUndeploy();
            this.active = false;
        }
    }

    private void performUndeploy() {
        if (this.undeployHttpService != null) {
            try {
                for (Map.Entry<String, Servlet> entry : this.servlets.entrySet()) {
                    this.undeployHttpService.unregister(entry.getKey());
                }
                for (Map.Entry<String, Object> entry : this.resources.entrySet()) {
                    this.undeployHttpService.unregister(entry.getKey());
                }
            }
            catch (ServiceUnavailableException serviceUnavailableException) {}
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"undeploy() called when httpService was null. destroy() methods of servlets may not have been called.");
        }
    }

    private void publishService() {
        Bundle bundle = this.getDeploymentContext().getBundle();
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("com.mtvnet.boxspring.osgi.webapp.name", bundle.getSymbolicName());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Publishing webapp as OSGi service with properties " + serviceProperties));
        }
        bundle.getBundleContext().registerService(WarDeployment.class.getName(), (Object)this, serviceProperties);
    }
}

