/*
 * Decompiled with CFR 0.152.
 */
package com.moz.fiji.schema.extra.tools;

import com.moz.fiji.common.flags.Flag;
import com.moz.fiji.common.flags.FlagParser;
import com.moz.fiji.schema.tools.BaseTool;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Console$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001=\u0011q\"\u00138ta\u0016\u001cGOR5mKR{w\u000e\u001c\u0006\u0003\u0007\u0011\tQ\u0001^8pYNT!!\u0002\u0004\u0002\u000b\u0015DHO]1\u000b\u0005\u001dA\u0011AB:dQ\u0016l\u0017M\u0003\u0002\n\u0015\u0005!a-\u001b6j\u0015\tYA\"A\u0002n_jT\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001\"!E\n\u000e\u0003IQ!a\u0001\u0004\n\u0005Q\u0011\"\u0001\u0003\"bg\u0016$vn\u001c7\t\u000bY\u0001A\u0011A\f\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005\u0011\u0001bB\u000e\u0001\u0005\u0004%i\u0001H\u0001\u0004\u0019><W#A\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013!B:mMRR'\"\u0001\u0012\u0002\u0007=\u0014x-\u0003\u0002%?\t1Aj\\4hKJDaA\n\u0001!\u0002\u001bi\u0012\u0001\u0002'pO\u0002Bq\u0001\u000b\u0001A\u0002\u0013\u0005\u0011&\u0001\u0004g_Jl\u0017\r^\u000b\u0002UA\u00111&\r\b\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'L\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$AB*ue&twM\u0003\u00021[!9Q\u0007\u0001a\u0001\n\u00031\u0014A\u00034pe6\fGo\u0018\u0013fcR\u0011qG\u000f\t\u0003YaJ!!O\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bwQ\n\t\u00111\u0001+\u0003\rAH%\r\u0005\u0007{\u0001\u0001\u000b\u0015\u0002\u0016\u0002\u000f\u0019|'/\\1uA!2AhP$I\u0013*\u0003\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u000b\u0019d\u0017mZ:\u000b\u0005\u0011C\u0011AB2p[6|g.\u0003\u0002G\u0003\n!a\t\\1h\u0003\u0011q\u0017-\\3\"\u0003!\nQ!^:bO\u0016\f\u0013aS\u0001;\r&dW\r\t4pe6\fGO\f\u0011P]\u0016\u0004sN\u001a\u0011(i\u0016DHo\n\u0017!OM,\u0017o\n\u0017!O!4\u0017\u000e\\3(Y\u0001:S.\u00199(Y\u0001:\u0013M\u001e:pO9Bq!\u0014\u0001A\u0002\u0013\u0005\u0011&\u0001\u0005qCRDg\t\\1h\u0011\u001dy\u0005\u00011A\u0005\u0002A\u000bA\u0002]1uQ\u001ac\u0017mZ0%KF$\"aN)\t\u000fmr\u0015\u0011!a\u0001U!11\u000b\u0001Q!\n)\n\u0011\u0002]1uQ\u001ac\u0017m\u001a\u0011)\rI{t)V%XC\u00051\u0016\u0001\u00029bi\"\f\u0013\u0001W\u0001S!\u0006$\b\u000eI8gAQDW\r\t4jY\u0016\u0004Co\u001c\u0011ek6\u0004h\u0006I'bs\u0002\nGn]8!E\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0011bg\u0002\ng\u000eI;o]\u0006lW\r\u001a\u0011q_NLG/[8oC2\u0004\u0013M]4v[\u0016tGO\f\u0005\u00065\u0002!\teW\u0001\bO\u0016$h*Y7f)\u0005Q\u0003\"B/\u0001\t\u0003Z\u0016aC4fi\u000e\u000bG/Z4pefDQa\u0018\u0001\u0005Bm\u000babZ3u\t\u0016\u001c8M]5qi&|g\u000eC\u0003b\u0001\u0011\u00053,\u0001\bhKR,6/Y4f'R\u0014\u0018N\\4\t\u000b\r\u0004A\u0011\u00023\u0002!I,\u0017\rZ*fcV,gnY3GS2,GCA\u001cf\u0011\u00151&\r1\u0001g!\t9g.D\u0001i\u0015\tI'.\u0001\u0002gg*\u00111\u000e\\\u0001\u0007Q\u0006$wn\u001c9\u000b\u00055\f\u0013AB1qC\u000eDW-\u0003\u0002pQ\n!\u0001+\u0019;i\u0011\u0015\t\b\u0001\"\u0003s\u0003-\u0011X-\u00193NCB4\u0015\u000e\\3\u0015\u0005]\u001a\b\"\u0002,q\u0001\u00041\u0007\"B;\u0001\t\u00131\u0018!\u0003:fC\u0012De)\u001b7f)\t9t\u000fC\u0003Wi\u0002\u0007a\rC\u0003z\u0001\u0011\u0005!0A\tsK\u0006$\u0017I\u001e:p\u0007>tG/Y5oKJ$\"aN>\t\u000bYC\b\u0019\u00014\t\u000bu\u0004A\u0011\u0001@\u0002\u0019I,\u0017\r\u001a+fqR4\u0015\u000e\\3\u0015\u0005]z\b\"\u0002,}\u0001\u00041\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000ee\u0016\fGMR5mKN#\u0018M\u001d;\u0015\u0011\u0005\u001d\u00111CA\u000b\u0003G\u0001R\u0001LA\u0005\u0003\u001bI1!a\u0003.\u0005\u0015\t%O]1z!\ra\u0013qB\u0005\u0004\u0003#i#\u0001\u0002\"zi\u0016DaAVA\u0001\u0001\u00041\u0007\u0002CA\f\u0003\u0003\u0001\r!!\u0007\u0002\t\r|gN\u001a\t\u0005\u00037\ty\"\u0004\u0002\u0002\u001e)\u0019\u0011q\u00036\n\t\u0005\u0005\u0012Q\u0004\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u0015\u0005\u0015\u0012\u0011\u0001I\u0001\u0002\u0004\t9#\u0001\u0004oEf$Xm\u001d\t\u0004Y\u0005%\u0012bAA\u0016[\t\u0019\u0011J\u001c;\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u00059\u0011n]'bO&\u001cGCBA\u001a\u0003s\ti\u0004E\u0002-\u0003kI1!a\u000e.\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u000f\u0002.\u0001\u0007\u0011qA\u0001\u0006Ef$Xm\u001d\u0005\t\u0003\u007f\ti\u00031\u0001\u0002\b\u0005)Q.Y4jG\"I\u00111\t\u0001C\u0002\u0013\u0015\u0011QI\u0001\u0017\u0003Z\u0014xnQ8oi\u0006Lg.\u001a:GS2,W*Y4jGV\u0011\u0011q\u0001\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0004\u0002\b\u00059\u0012I\u001e:p\u0007>tG/Y5oKJ4\u0015\u000e\\3NC\u001eL7\r\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0003\u0003\u000b\n\u0011cU3rk\u0016t7-\u001a$jY\u0016l\u0015mZ5d\u0011!\t\t\u0006\u0001Q\u0001\u000e\u0005\u001d\u0011AE*fcV,gnY3GS2,W*Y4jG\u0002Bq!!\u0016\u0001\t\u0003\t9&A\u0007hk\u0016\u001c8OR5mKRK\b/\u001a\u000b\u0007\u00033\ny&!\u0019\u0011\t1\nYFK\u0005\u0004\u0003;j#AB(qi&|g\u000e\u0003\u0004W\u0003'\u0002\rA\u001a\u0005\t\u0003/\t\u0019\u00061\u0001\u0002\u001a!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0014a\u0001:v]R!\u0011qEA5\u0011!\tY'a\u0019A\u0002\u00055\u0014\u0001C;oa\u0006\u00148/\u001a3\u0011\u000b\u0005=\u0014\u0011\u0010\u0016\u000e\u0005\u0005E$\u0002BA:\u0003k\nA!\u001e;jY*\u0011\u0011qO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0005E$\u0001\u0002'jgRD\u0011\"a \u0001#\u0003%\t!!!\u0002/I,\u0017\r\u001a$jY\u0016\u001cF/\u0019:uI\u0011,g-Y;mi\u0012\u001aTCAABU\u0011\t9#!\",\u0005\u0005\u001d\u0005\u0003BAE\u0003'k!!a#\u000b\t\u00055\u0015qR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!%.\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\u000bYIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class InspectFileTool
extends BaseTool {
    private final Logger Log = LoggerFactory.getLogger(InspectFileTool.class);
    @Flag(name="format", usage="File format. One of 'text', 'seq', 'hfile', 'map', 'avro'.")
    private String format = null;
    @Flag(name="path", usage="Path of the file to dump. May also be specified as an unnamed positional argument.")
    private String pathFlag = null;
    private final byte[] AvroContainerFileMagic = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{79, 98, 106}), ClassTag$.MODULE$.Byte());
    private final byte[] SequenceFileMagic = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{83, 69, 81}), ClassTag$.MODULE$.Byte());

    private final Logger Log() {
        return this.Log;
    }

    public String format() {
        return this.format;
    }

    public void format_$eq(String x$1) {
        this.format = x$1;
    }

    public String pathFlag() {
        return this.pathFlag;
    }

    public void pathFlag_$eq(String x$1) {
        this.pathFlag = x$1;
    }

    public String getName() {
        return "cat";
    }

    public String getCategory() {
        return "extra";
    }

    public String getDescription() {
        return "Dumps the content of a file.";
    }

    public String getUsageString() {
        return new StringOps(Predef$.MODULE$.augmentString("Usage:\n        |    fiji cat [--path=]<path> [--format=(text|seq|avro|map|hfile)]\n        |")).stripMargin();
    }

    private void readSequenceFile(Path path) {
        try (SequenceFile.Reader reader = new SequenceFile.Reader(this.getConf(), new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});){
            Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("Key class: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getKeyClassName()})));
            Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("Value class: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getValueClassName()})));
            Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("Compression type: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getCompressionType()})));
            Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("Compression codec: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getCompressionCodec()})));
            if (reader.getMetadata().getMetadata().isEmpty()) {
                Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("File '%s' has no metadata")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
            } else {
                Console$.MODULE$.err().println(new StringOps(Predef$.MODULE$.augmentString("Metadata:%n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getMetadata().getMetadata()})));
            }
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.getConf());
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.getConf());
            while (true) {
                long position = reader.getPosition();
                if (!reader.next(key, value)) break;
                Console$.MODULE$.out().println(new StringOps(Predef$.MODULE$.augmentString("position=%s\tkey=%s\tvalue=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)position), key, value})));
            }
            return;
        }
    }

    private void readMapFile(Path path) {
        try (MapFile.Reader reader = new MapFile.Reader(path, this.getConf(), new SequenceFile.Reader.Option[0]);){
            WritableComparable key = (WritableComparable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)this.getConf());
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)this.getConf());
            while (reader.next(key, value)) {
                Console$.MODULE$.out().println(new StringOps(Predef$.MODULE$.augmentString("key=%s\tvalue=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
            }
            return;
        }
    }

    private void readHFile(Path path) {
        CacheConfig cacheConf = new CacheConfig(this.getConf());
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        try (HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)cacheConf, (Configuration)this.getConf());){
            boolean cacheBlocks = false;
            boolean positionalRead = false;
            HFileScanner scanner = reader.getScanner(cacheBlocks, positionalRead);
            boolean hasNext = scanner.seekTo();
            while (hasNext) {
                KeyValue keyValue = scanner.getKeyValue();
                byte[] rowKey = keyValue.getRow();
                byte[] family = keyValue.getFamily();
                byte[] qualifier = keyValue.getQualifier();
                long timestamp = keyValue.getTimestamp();
                byte[] value = keyValue.getValue();
                Console$.MODULE$.out().println(new StringOps(Predef$.MODULE$.augmentString("row=%-30sfamily=%-10squalifer=%-10stimestamp=%s\tvalue=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Bytes.toStringBinary((byte[])rowKey), Bytes.toStringBinary((byte[])family), Bytes.toStringBinary((byte[])qualifier), BoxesRunTime.boxToLong((long)timestamp), Bytes.toStringBinary((byte[])value)})));
                hasNext = scanner.next();
            }
            return;
        }
    }

    public void readAvroContainer(Path path) {
        FileContext context = FileContext.getFileContext();
        AvroFSInput input = new AvroFSInput(context, path);
        GenericDatumReader datumReader = new GenericDatumReader();
        try (FileReader reader = DataFileReader.openReader((SeekableInput)input, (DatumReader)datumReader);){
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Schema:\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reader.getSchema().toString(true)})));
            int counter = 0;
            while (reader.hasNext()) {
                Object rec = reader.next();
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("entry #%d: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counter), rec})));
                ++counter;
            }
            return;
        }
    }

    public void readTextFile(Path path) {
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        try (FSDataInputStream istream = fs.open(path);){
            IOUtils.copy((InputStream)istream, (OutputStream)Console$.MODULE$.out());
            return;
        }
    }

    public byte[] readFileStart(Path path, Configuration conf, int nbytes) {
        FileSystem fs = FileSystem.get((Configuration)conf);
        try (FSDataInputStream istream = fs.open(path);){
            byte[] bytes = new byte[16];
            int nbytesRead = istream.read(bytes);
            return (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(0, nbytesRead);
        }
    }

    public int readFileStart$default$3() {
        return 16;
    }

    public boolean isMagic(byte[] bytes, byte[] magic) {
        return Arrays.equals((byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(0, magic.length), magic);
    }

    public final byte[] AvroContainerFileMagic() {
        return this.AvroContainerFileMagic;
    }

    public final byte[] SequenceFileMagic() {
        return this.SequenceFileMagic;
    }

    public Option<String> guessFileType(Path path, Configuration conf) {
        try {
            byte[] bytes = this.readFileStart(path, conf, this.readFileStart$default$3());
            if (this.isMagic(bytes, this.AvroContainerFileMagic())) {
                return new Some((Object)"avro");
            }
            if (this.isMagic(bytes, this.SequenceFileMagic())) {
                return new Some((Object)"seq");
            }
        }
        catch (Throwable throwable) {
            Console$.MODULE$.err().println(throwable);
        }
        return None$.MODULE$;
    }

    public int run(List<String> unparsed) {
        block9: {
            block15: {
                block11: {
                    String string;
                    Path filePath;
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    if (!(unparsed.size() == 1 ^ (this.pathFlag() != null && unparsed.isEmpty()))) break block9;
                                    String path = this.pathFlag() == null ? unparsed.get(0) : this.pathFlag();
                                    filePath = new Path(path);
                                    if (this.format() == null) {
                                        String string2;
                                        Option<String> option = this.guessFileType(filePath, this.getConf());
                                        if (option instanceof Some) {
                                            String fmt;
                                            Some some = (Some)option;
                                            string2 = fmt = (String)some.x();
                                        } else {
                                            None$ none$ = None$.MODULE$;
                                            Option<String> option2 = option;
                                            if (none$ != null ? !none$.equals(option2) : option2 != null) {
                                                throw new MatchError(option);
                                            }
                                            string2 = "text";
                                        }
                                        this.format_$eq(string2);
                                        this.Log().info("Detected file type: {}", new Object[]{this.format()});
                                    }
                                    String string3 = string = this.format();
                                    if ("seq" != null ? !"seq".equals(string3) : string3 != null) break block10;
                                    this.readSequenceFile(filePath);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block11;
                                }
                                String string4 = string;
                                if ("map" != null ? !"map".equals(string4) : string4 != null) break block12;
                                this.readMapFile(filePath);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block11;
                            }
                            String string5 = string;
                            if ("hfile" != null ? !"hfile".equals(string5) : string5 != null) break block13;
                            this.readHFile(filePath);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block11;
                        }
                        String string6 = string;
                        if ("avro" != null ? !"avro".equals(string6) : string6 != null) break block14;
                        this.readAvroContainer(filePath);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block11;
                    }
                    String string7 = string;
                    if ("text" != null ? !"text".equals(string7) : string7 != null) break block15;
                    this.readTextFile(filePath);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return 0;
            }
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Unknown file format: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.format()})));
        }
        FlagParser.printUsage((Object)((Object)this), (PrintStream)Console$.MODULE$.out());
        return 1;
    }
}

