/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiUrl {
    private static final Logger LOG = LoggerFactory.getLogger(ApiUrl.class);
    private static final String API_URL = "http://api.allocine.fr/rest/v3/";
    private static final String PARAM_PARTNER = "?partner=";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private final String partnerKey;
    private final String secretKey;
    private static final String URL_ENCODING = "UTF-8";
    private static final String PREFIX_SED = "&sed=";
    private static final String PREFIX_SIG = "&sig=";

    public ApiUrl(String partnerKey, String secretKey) {
        this.partnerKey = partnerKey;
        this.secretKey = secretKey;
    }

    public String generateUrl(String method, Map<String, String> params) {
        String sed = ApiUrl.buildSed();
        String paramUrl = this.buildParams(params);
        StringBuilder key = new StringBuilder(this.secretKey);
        key.append(paramUrl.substring(1));
        key.append(PREFIX_SED);
        key.append(sed);
        byte[] sha1code = DigestUtils.sha1((String)key.toString());
        String sig = "";
        try {
            sig = ApiUrl.encoder(new String(Base64.encodeBase64((byte[])sha1code), URL_ENCODING));
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn("Failed to encode: {}", (Object)ex.getMessage(), (Object)ex);
        }
        StringBuilder url = new StringBuilder(API_URL);
        url.append(method);
        url.append(paramUrl);
        url.append(PREFIX_SED).append(sed);
        url.append(PREFIX_SIG).append(sig);
        LOG.trace("URL: {}", (Object)url);
        return url.toString();
    }

    private static String encoder(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, URL_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn("Failed to encode: {}", (Object)ex.getMessage(), (Object)ex);
            return "";
        }
    }

    private static String buildSed() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    private String buildParams(Map<String, String> params) {
        StringBuilder paramUrl = new StringBuilder();
        paramUrl.append(PARAM_PARTNER).append(this.partnerKey);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            paramUrl.append("&").append(entry.getKey());
            paramUrl.append("=").append(ApiUrl.encoder(entry.getValue()));
        }
        return paramUrl.toString();
    }
}

