/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.moviejukebox.allocine.model.Rating;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonRootName(value="statistics")
public class Statistics {
    private final Map<String, Object> stats = new HashMap<String, Object>();
    @JsonProperty(value="rating")
    private List<Rating> ratings;

    @JsonAnySetter
    public void addStat(String key, Object value) {
        this.stats.put(key, value);
    }

    public List<Rating> getRatings() {
        return this.ratings;
    }

    public boolean hasStatistic(String statisticName) {
        return this.stats.containsKey(statisticName);
    }

    public Object getStatistic(String statisticName) {
        return this.stats.get(statisticName);
    }

    public Integer getIntegerStatistic(String statisticName) {
        Integer stat = this.getStatistic(statisticName, Integer.class);
        return stat == null ? -1 : stat;
    }

    public Double getDoubleStatistic(String statisticName) {
        Double stat = this.getStatistic(statisticName, Double.class);
        return stat == null ? -1.0 : stat;
    }

    public <T> T getStatistic(String statisticName, Class<T> clazz) {
        if (statisticName == null || "".equals(statisticName) || this.stats.get(statisticName) == null) {
            return null;
        }
        return clazz.cast(this.stats.get(statisticName));
    }
}

