/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.moviejukebox.allocine.model.AbstractBaseInfos;
import com.moviejukebox.allocine.model.CodeName;
import com.moviejukebox.allocine.model.FestivalAward;
import com.moviejukebox.allocine.model.Movie;
import com.moviejukebox.allocine.model.MoviePerson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MovieInfos
extends AbstractBaseInfos {
    private static final long serialVersionUID = 100L;
    private static final Pattern AGE_REGEXP = Pattern.compile("\\s(\\d{1,2})\\san");
    @JsonProperty(value="movie")
    private Movie movie;

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
    }

    public boolean isValid() {
        if (this.movie == null) {
            return false;
        }
        return this.movie.getCode() > 0;
    }

    public boolean isNotValid() {
        return !this.isValid();
    }

    public int getCode() {
        return this.getCode(this.movie);
    }

    public String getTitle() {
        return this.getTitle(this.movie);
    }

    public String getOriginalTitle() {
        return this.getOriginalTitle(this.movie);
    }

    public int getProductionYear() {
        if (this.movie == null) {
            return -1;
        }
        return this.movie.getProductionYear();
    }

    public int getRuntime() {
        if (this.movie == null) {
            return -1;
        }
        return this.movie.getRuntime();
    }

    public String getReleaseDate() {
        return this.getReleaseDate(this.movie);
    }

    public String getReleaseCountry() {
        return this.getReleaseCountry(this.movie);
    }

    public String getSynopsis() {
        return this.getSynopsis(this.movie);
    }

    public String getSynopsisShort() {
        return this.getSynopsisShort(this.movie);
    }

    public int getUserRating() {
        return this.getUserRating(this.movie);
    }

    public int getPressRating() {
        return this.getPressRating(this.movie);
    }

    public String getCertification() {
        Matcher match;
        CodeName certificate;
        String certification = "All";
        if (this.movie != null && this.movie.getMovieCertificate() != null && (certificate = this.movie.getMovieCertificate().getCertificate()) != null && (match = AGE_REGEXP.matcher(certificate.getName())).find()) {
            certification = match.group(1);
        }
        return certification;
    }

    public Set<String> getGenres() {
        return this.getGenres(this.movie);
    }

    public Set<String> getNationalities() {
        return this.getNationalities(this.movie);
    }

    public String getDistributor() {
        if (this.movie == null) {
            return null;
        }
        if (this.movie.getRelease() != null && this.movie.getRelease().getDistributor() != null) {
            return this.movie.getRelease().getDistributor().getName();
        }
        return null;
    }

    public Set<MoviePerson> getActors() {
        return this.getActors(this.movie);
    }

    public Set<MoviePerson> getDirectors() {
        return this.getDirectors(this.movie);
    }

    public Set<MoviePerson> getWriters() {
        return this.getWriters(this.movie);
    }

    public Set<MoviePerson> getCamera() {
        return this.getCamera(this.movie);
    }

    public Set<MoviePerson> getProducers() {
        return this.getProducers(this.movie);
    }

    public Map<String, Long> getPosters() {
        return this.getPosters(this.movie);
    }

    public List<FestivalAward> getFestivalAwards() {
        if (this.movie != null) {
            return this.movie.getFestivalAwards();
        }
        return Collections.emptyList();
    }
}

