/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.moviejukebox.allocine.model.AbstractPersonInfo;
import com.moviejukebox.allocine.model.Participance;
import com.moviejukebox.allocine.model.Participation;
import com.moviejukebox.allocine.model.Season;
import com.moviejukebox.allocine.tools.HtmlTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FilmographyInfos
extends AbstractPersonInfo {
    private static final long serialVersionUID = 100L;
    private List<Participance> participances = null;

    public List<Participance> getParticipances() {
        if (this.getPerson() == null) {
            return Collections.emptyList();
        }
        if (this.participances == null) {
            this.participances = this.processParticipance();
        }
        return this.participances;
    }

    private List<Participance> processParticipance() {
        ArrayList<Participance> newParticipances = new ArrayList<Participance>();
        if (this.getPerson().getParticipations() != null) {
            for (Participation p : this.getPerson().getParticipations()) {
                if (!FilmographyInfos.validParticipation(p)) continue;
                Participance participance = new Participance(p.getTvSeries() != null);
                participance.setRole(p.getRole());
                participance.setActor(p.getActivity().isActor());
                participance.setDirector(p.getActivity().isDirector());
                participance.setWriter(p.getActivity().isWriter());
                participance.setCamera(p.getActivity().isCamera());
                participance.setProducer(p.getActivity().isProducer());
                if (p.getTvSeries() != null) {
                    FilmographyInfos.processTV(participance, p);
                } else {
                    FilmographyInfos.processMovie(participance, p);
                }
                newParticipances.add(participance);
            }
        }
        return newParticipances;
    }

    private static boolean validParticipation(Participation p) {
        if (p.getActivity() == null || p.getActivity().isUnknown()) {
            return false;
        }
        if (p.getMovie() != null) {
            return p.getMovie().getProductionYear() > 0;
        }
        if (p.getTvSeries() != null) {
            return p.getTvSeries().getYearStart() > 0;
        }
        return false;
    }

    private static void processTV(Participance participance, Participation p) {
        participance.setCode(p.getTvSeries().getCode());
        participance.setTitle(p.getTvSeries().getTitle());
        participance.setOriginalTitle(p.getTvSeries().getOriginalTitle());
        participance.setSynopsisShort(p.getTvSeries().getSynopsisShort());
        participance.setYearStart(p.getTvSeries().getYearStart());
        participance.setYearEnd(p.getTvSeries().getYearEnd());
        if (p.getTvSeries().getSeasonList() != null && p.getTvSeries().getSeasonList().size() == 1) {
            Season season = p.getTvSeries().getSeasonList().get(0);
            participance.setSeasonCode(season.getCode());
            participance.setSeasonNumber(season.getSeasonNumber());
        }
    }

    private static void processMovie(Participance participance, Participation p) {
        participance.setCode(p.getMovie().getCode());
        participance.setTitle(p.getMovie().getTitle());
        participance.setOriginalTitle(p.getMovie().getOriginalTitle());
        participance.setSynopsisShort(HtmlTools.removeLineFeeds(p.getMovie().getSynopsisShort()));
        participance.setYear(p.getMovie().getProductionYear());
        if (p.getMovie().getRelease() != null) {
            participance.setReleaseDate(p.getMovie().getRelease().getReleaseDate());
            if (p.getMovie().getRelease().getCountry() != null) {
                participance.setReleaseCountry(p.getMovie().getRelease().getCountry().getName());
            }
        }
    }
}

