/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.moviejukebox.allocine.model.AbstractBaseInfos;
import com.moviejukebox.allocine.model.Episode;
import com.moviejukebox.allocine.model.MoviePerson;
import java.util.Set;

public class EpisodeInfos
extends AbstractBaseInfos {
    private static final long serialVersionUID = 100L;
    @JsonProperty(value="episode")
    private Episode episode;

    public Episode getEpisode() {
        return this.episode;
    }

    public void setEpisode(Episode episode) {
        this.episode = episode;
    }

    public boolean isValid() {
        if (this.episode == null) {
            return false;
        }
        return this.episode.getCode() > 0;
    }

    public boolean isNotValid() {
        return !this.isValid();
    }

    public int getCode() {
        return this.getCode(this.episode);
    }

    public String getTitle() {
        return this.getTitle(this.episode);
    }

    public String getOriginalTitle() {
        return this.getOriginalTitle(this.episode);
    }

    public String getSynopsis() {
        if (this.episode == null) {
            return null;
        }
        return this.episode.getSynopsis();
    }

    public String getSynopsisShort() {
        if (this.episode == null) {
            return null;
        }
        return this.episode.getSynopsisShort();
    }

    public String getOriginalBroadcastDate() {
        if (this.episode == null) {
            return null;
        }
        return this.episode.getOriginalBroadcastDate();
    }

    public int getEpisodeNumberSeries() {
        if (this.episode == null) {
            return -1;
        }
        return this.episode.getEpisodeNumberSeries();
    }

    public int getEpisodeNumberSeason() {
        if (this.episode == null) {
            return -1;
        }
        return this.episode.getEpisodeNumberSeason();
    }

    public Set<MoviePerson> getActors() {
        return this.getActors(this.episode);
    }

    public Set<MoviePerson> getDirectors() {
        return this.getDirectors(this.episode);
    }

    public Set<MoviePerson> getWriters() {
        return this.getWriters(this.episode);
    }

    public Set<MoviePerson> getCamera() {
        return this.getCamera(this.episode);
    }

    public Set<MoviePerson> getProducers() {
        return this.getProducers(this.episode);
    }
}

