/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.fasterxml.jackson.annotation.JsonRootName;
import com.moviejukebox.allocine.model.CodeName;
import com.moviejukebox.allocine.model.enumeration.Job;
import java.util.HashMap;
import java.util.Map;

@JsonRootName(value="activity")
public class Activity
extends CodeName {
    private static final long serialVersionUID = 100L;
    private static final int ACTOR_CODE = 8001;
    private static final int DIRECTOR_CODE = 8002;
    private static final int PRODUCER_CODE = 8029;
    private static final int DELEGATE_PRODUCER_CODE = 8061;
    private static final int EXECUTIVE_PRODUCER_CODE = 8062;
    private static final int COPRODUCER_CODE = 8063;
    private static final int ASSOCIATE_PRODUCER_CODE = 8064;
    private static final int WRITER_CODE = 8004;
    private static final int SCRIPT_CODE = 8043;
    private static final int CAMERA_CODE = 8037;
    private Job job = Job.UNKNOWN;
    private static final Map<Integer, Job> JOB_LIST = new HashMap<Integer, Job>();

    @Override
    public void setCode(int code) {
        super.setCode(code);
        this.job = JOB_LIST.get(code);
        if (this.job == null) {
            this.job = Job.UNKNOWN;
        }
    }

    private boolean hasJob(Job job) {
        return this.job == job;
    }

    public boolean isActor() {
        return this.hasJob(Job.ACTOR);
    }

    public boolean isDirector() {
        return this.hasJob(Job.DIRECTOR);
    }

    public boolean isWriter() {
        return this.hasJob(Job.WRITER);
    }

    public boolean isCamera() {
        return this.hasJob(Job.CAMERA);
    }

    public boolean isProducer() {
        return this.hasJob(Job.PRODUCER);
    }

    public boolean isUnknown() {
        return this.hasJob(Job.UNKNOWN);
    }

    static {
        JOB_LIST.put(8001, Job.ACTOR);
        JOB_LIST.put(8002, Job.DIRECTOR);
        JOB_LIST.put(8029, Job.PRODUCER);
        JOB_LIST.put(8061, Job.PRODUCER);
        JOB_LIST.put(8062, Job.PRODUCER);
        JOB_LIST.put(8063, Job.PRODUCER);
        JOB_LIST.put(8064, Job.PRODUCER);
        JOB_LIST.put(8004, Job.WRITER);
        JOB_LIST.put(8043, Job.WRITER);
        JOB_LIST.put(8037, Job.CAMERA);
    }
}

