/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine.model;

import com.moviejukebox.allocine.model.AbstractBaseMapping;
import com.moviejukebox.allocine.model.AbstractJsonMapping;
import com.moviejukebox.allocine.model.CastMember;
import com.moviejukebox.allocine.model.CodeName;
import com.moviejukebox.allocine.model.MoviePerson;
import com.moviejukebox.allocine.model.media.MediaBasic;
import com.moviejukebox.allocine.tools.HtmlTools;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBaseInfos
extends AbstractJsonMapping {
    private static final double PERCENT_OUT_OF_5 = 5.0;
    private static final int PERCENT_OUT_OF_100 = 100;
    private Set<String> genres;
    private Set<String> nationalities;
    private Map<String, Long> posters;

    protected int getCode(AbstractBaseMapping base) {
        return base == null ? -1 : base.getCode();
    }

    protected String getTitle(AbstractBaseMapping base) {
        return base == null ? null : base.getTitle();
    }

    protected String getOriginalTitle(AbstractBaseMapping base) {
        return base == null ? null : base.getOriginalTitle();
    }

    protected String getSynopsis(AbstractBaseMapping base) {
        return base == null ? null : HtmlTools.removeLineFeeds(base.getSynopsis());
    }

    protected String getSynopsisShort(AbstractBaseMapping base) {
        return base == null ? null : HtmlTools.removeLineFeeds(base.getSynopsisShort());
    }

    protected int getUserRating(AbstractBaseMapping base) {
        if (base == null || base.getStatistics() == null) {
            return -1;
        }
        Double userRating = base.getStatistics().getDoubleStatistic("userRating");
        if (userRating == null) {
            return -1;
        }
        return (int)(userRating / 5.0 * 100.0);
    }

    protected int getPressRating(AbstractBaseMapping base) {
        if (base == null || base.getStatistics() == null) {
            return -1;
        }
        Double pressRating = base.getStatistics().getDoubleStatistic("pressRating");
        if (pressRating == null) {
            return -1;
        }
        return (int)(pressRating / 5.0 * 100.0);
    }

    protected Set<String> getGenres(AbstractBaseMapping base) {
        if (base == null) {
            return Collections.emptySet();
        }
        if (this.genres == null) {
            this.genres = new HashSet<String>();
            if (base.getGenre() != null) {
                for (CodeName genre : base.getGenre()) {
                    this.genres.add(genre.getName());
                }
            }
        }
        return this.genres;
    }

    protected Set<String> getNationalities(AbstractBaseMapping base) {
        if (base == null) {
            return Collections.emptySet();
        }
        if (this.nationalities == null) {
            this.nationalities = new HashSet<String>();
            if (base.getNationality() != null) {
                for (CodeName nationality : base.getNationality()) {
                    this.nationalities.add(nationality.getName());
                }
            }
        }
        return this.nationalities;
    }

    protected Set<MoviePerson> getActors(AbstractBaseMapping base) {
        LinkedHashSet<MoviePerson> set = new LinkedHashSet<MoviePerson>();
        if (base != null && base.getCastMember() != null) {
            for (CastMember member : base.getCastMember()) {
                MoviePerson person = AbstractBaseInfos.createPersonActor(member);
                if (person == null) continue;
                set.add(person);
            }
        }
        return set;
    }

    private static MoviePerson createPersonActor(CastMember member) {
        if (member.isActor()) {
            MoviePerson person = new MoviePerson();
            person.setCode(member.getShortPerson().getCode());
            person.setName(member.getShortPerson().getName());
            person.setRole(member.getRole());
            person.setLeadActor(member.isLeadActor());
            if (member.getPicture() != null) {
                person.setPhotoURL(member.getPicture().getHref());
            }
            return person;
        }
        return null;
    }

    protected Set<MoviePerson> getDirectors(AbstractBaseMapping base) {
        LinkedHashSet<MoviePerson> set = new LinkedHashSet<MoviePerson>();
        if (base != null && base.getCastMember() != null) {
            for (CastMember member : base.getCastMember()) {
                if (!member.isDirector()) continue;
                AbstractBaseInfos.addMember(member, set);
            }
        }
        return set;
    }

    protected Set<MoviePerson> getWriters(AbstractBaseMapping base) {
        LinkedHashSet<MoviePerson> set = new LinkedHashSet<MoviePerson>();
        if (base != null && base.getCastMember() != null) {
            for (CastMember member : base.getCastMember()) {
                if (!member.isWriter()) continue;
                AbstractBaseInfos.addMember(member, set);
            }
        }
        return set;
    }

    protected Set<MoviePerson> getCamera(AbstractBaseMapping base) {
        LinkedHashSet<MoviePerson> set = new LinkedHashSet<MoviePerson>();
        if (base != null && base.getCastMember() != null) {
            for (CastMember member : base.getCastMember()) {
                if (!member.isCamera()) continue;
                AbstractBaseInfos.addMember(member, set);
            }
        }
        return set;
    }

    protected Set<MoviePerson> getProducers(AbstractBaseMapping base) {
        LinkedHashSet<MoviePerson> set = new LinkedHashSet<MoviePerson>();
        if (base != null && base.getCastMember() != null) {
            for (CastMember member : base.getCastMember()) {
                if (!member.isProducer()) continue;
                AbstractBaseInfos.addMember(member, set);
            }
        }
        return set;
    }

    private static void addMember(CastMember member, Set<MoviePerson> persons) {
        MoviePerson person = new MoviePerson();
        person.setCode(member.getShortPerson().getCode());
        person.setName(member.getShortPerson().getName());
        if (member.getPicture() != null) {
            person.setPhotoURL(member.getPicture().getHref());
        }
        persons.add(person);
    }

    private void parseMediaList(AbstractBaseMapping base) {
        if (base == null) {
            return;
        }
        if (this.posters == null) {
            this.posters = new LinkedHashMap<String, Long>();
        }
        if (base.getPoster() != null) {
            this.posters.put(base.getPoster().getHref(), Long.valueOf(base.getCode()));
        }
        if (base.getMedia() != null) {
            for (MediaBasic medium : base.getMedia()) {
                if (!medium.isPoster() || medium.getThumbnail() == null) continue;
                this.posters.put(medium.getThumbnail().getHref(), medium.getRcode());
            }
        }
    }

    protected Map<String, Long> getPosters(AbstractBaseMapping base) {
        if (this.posters == null) {
            this.parseMediaList(base);
        }
        return this.posters;
    }

    protected String getReleaseDate(AbstractBaseMapping base) {
        if (base == null) {
            return null;
        }
        if (base.getRelease() == null) {
            return null;
        }
        return base.getRelease().getReleaseDate();
    }

    protected String getReleaseCountry(AbstractBaseMapping base) {
        if (base == null) {
            return null;
        }
        if (base.getRelease() == null) {
            return null;
        }
        if (base.getRelease().getCountry() == null) {
            return null;
        }
        return base.getRelease().getCountry().getName();
    }
}

