/*
 * Decompiled with CFR 0.152.
 */
package com.moviejukebox.allocine;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.moviejukebox.allocine.AllocineException;
import com.moviejukebox.allocine.model.EpisodeInfos;
import com.moviejukebox.allocine.model.FilmographyInfos;
import com.moviejukebox.allocine.model.MovieInfos;
import com.moviejukebox.allocine.model.PersonInfos;
import com.moviejukebox.allocine.model.Search;
import com.moviejukebox.allocine.model.TvSeasonInfos;
import com.moviejukebox.allocine.model.TvSeriesInfos;
import com.moviejukebox.allocine.tools.ApiUrl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.exception.ApiExceptionType;
import org.yamj.api.common.http.AndroidBrowserUserAgentSelector;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.DigestedResponseReader;
import org.yamj.api.common.http.IUserAgentSelector;

public class AllocineApi {
    private static final String ERROR_FAILED_TO_CONVERT_URL = "Failed to convert URL";
    private static final String LITERAL_LARGE = "large";
    private static final String LITERAL_SYNOPSIS = "synopsis,synopsisshort";
    private static final int HTTP_STATUS_300 = 300;
    private static final int HTTP_STATUS_500 = 500;
    private static final String METHOD_SEARCH = "search";
    private static final String METHOD_MOVIE = "movie";
    private static final String METHOD_TVSERIES = "tvseries";
    private static final String METHOD_SEASON = "season";
    private static final String METHOD_EPISODE = "episode";
    private static final String METHOD_PERSON = "person";
    private static final String METHOD_FILMOGRAPHY = "filmography";
    private static final String FILTER_MOVIE = "movie";
    private static final String FILTER_TVSERIES = "tvseries";
    private static final String FILTER_PERSON = "person";
    private static final String PARAM_PROFILE = "profile";
    private static final String PARAM_MEDIAFMT = "mediafmt";
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_FORMAT = "format";
    private static final String PARAM_CODE = "code";
    private static final String PARAM_STRIPTAGS = "striptags";
    private static final String PARAM_FORMAT_VALUE = "json";
    private final ApiUrl apiUrl;
    private final HttpClient httpClient;
    private final ObjectMapper mapper;
    private final Charset charset;
    private final IUserAgentSelector userAgentSelector;

    public AllocineApi(String partnerKey, String secretKey, HttpClient httpClient) throws AllocineException {
        if (StringUtils.isBlank((CharSequence)partnerKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            throw new AllocineException(ApiExceptionType.AUTH_FAILURE, "Must provide a Partner and Sercret key");
        }
        this.apiUrl = new ApiUrl(partnerKey, secretKey);
        this.httpClient = httpClient;
        this.mapper = new ObjectMapper();
        this.charset = Charset.forName("UTF-8");
        this.userAgentSelector = new AndroidBrowserUserAgentSelector();
    }

    private <T> T readJsonObject(URL url, Class<T> object) throws AllocineException {
        String page = this.requestWebPage(url);
        if (StringUtils.isNotBlank((CharSequence)page)) {
            try {
                return (T)this.mapper.readValue(page, object);
            }
            catch (IOException ex) {
                LoggerFactory.getLogger((String)"test").info("{}", (Throwable)ex);
                throw new AllocineException(ApiExceptionType.MAPPING_FAILED, "Failed to read JSON object", url, (Throwable)ex);
            }
        }
        throw new AllocineException(ApiExceptionType.MAPPING_FAILED, "Failed to read JSON object", url);
    }

    public Search searchMovies(String query) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("q", query);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_FILTER, "movie");
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl(METHOD_SEARCH, params);
        try {
            return this.readJsonObject(new URL(url), Search.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public Search searchTvSeries(String query) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("q", query);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_FILTER, "tvseries");
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl(METHOD_SEARCH, params);
        try {
            return this.readJsonObject(new URL(url), Search.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public Search searchPersons(String query) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("q", query);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_FILTER, "person");
        params.put(PARAM_STRIPTAGS, "biography,biographyshort");
        String url = this.apiUrl.generateUrl(METHOD_SEARCH, params);
        try {
            return this.readJsonObject(new URL(url), Search.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public MovieInfos getMovieInfos(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_FILTER, "movie");
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl("movie", params);
        try {
            return this.readJsonObject(new URL(url), MovieInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public TvSeriesInfos getTvSeriesInfos(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_MEDIAFMT, "mp4-lc");
        params.put(PARAM_FILTER, "movie");
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl("tvseries", params);
        try {
            return this.readJsonObject(new URL(url), TvSeriesInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public TvSeasonInfos getTvSeasonInfos(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_MEDIAFMT, "mp4-lc");
        params.put(PARAM_FILTER, "movie");
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl(METHOD_SEASON, params);
        try {
            return this.readJsonObject(new URL(url), TvSeasonInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public PersonInfos getPersonInfos(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_STRIPTAGS, "biography,biographyshort");
        String url = this.apiUrl.generateUrl("person", params);
        try {
            return this.readJsonObject(new URL(url), PersonInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public FilmographyInfos getPersonFilmography(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl(METHOD_FILMOGRAPHY, params);
        try {
            return this.readJsonObject(new URL(url), FilmographyInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    public EpisodeInfos getEpisodeInfos(String allocineId) throws AllocineException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PARAM_PROFILE, LITERAL_LARGE);
        params.put(PARAM_FORMAT, PARAM_FORMAT_VALUE);
        params.put(PARAM_CODE, allocineId);
        params.put(PARAM_STRIPTAGS, LITERAL_SYNOPSIS);
        String url = this.apiUrl.generateUrl(METHOD_EPISODE, params);
        try {
            return this.readJsonObject(new URL(url), EpisodeInfos.class);
        }
        catch (MalformedURLException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, ERROR_FAILED_TO_CONVERT_URL, url, (Throwable)ex);
        }
    }

    private String requestWebPage(URL url) throws AllocineException {
        try {
            HttpGet httpGet = new HttpGet(url.toURI());
            httpGet.setHeader("accept", "application/json");
            httpGet.setHeader("User-Agent", this.userAgentSelector.getUserAgent());
            DigestedResponse response = DigestedResponseReader.requestContent((HttpClient)this.httpClient, (HttpGet)httpGet, (Charset)this.charset);
            if (response.getStatusCode() == 0) {
                throw new AllocineException(ApiExceptionType.CONNECTION_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            if (response.getStatusCode() >= 500) {
                throw new AllocineException(ApiExceptionType.HTTP_503_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            if (response.getStatusCode() >= 300) {
                throw new AllocineException(ApiExceptionType.HTTP_404_ERROR, response.getContent(), response.getStatusCode(), url);
            }
            return response.getContent();
        }
        catch (URISyntaxException ex) {
            throw new AllocineException(ApiExceptionType.INVALID_URL, "Invalid URL", url, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new AllocineException(ApiExceptionType.CONNECTION_ERROR, "Error retrieving URL", url, (Throwable)ex);
        }
    }
}

