/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.RadioButton;
import com.mottimotti.android.R;

public class RadioButtonCenteredImage
extends RadioButton {
    Drawable image;

    public RadioButtonCenteredImage(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CompoundButton, 0, 0);
        this.image = a.getDrawable(1);
        this.setButtonDrawable(17170445);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.image != null) {
            this.image.setState(this.getDrawableState());
            int imgHeight = this.image.getIntrinsicHeight();
            int imgWidth = this.image.getIntrinsicWidth();
            int btnWidth = this.getWidth();
            int btnHeight = this.getHeight();
            float scale = imgWidth <= btnWidth && imgHeight <= btnHeight ? 1.0f : Math.min((float)btnWidth / (float)imgWidth, (float)btnHeight / (float)imgHeight);
            int dx = (int)(((float)btnWidth - (float)imgWidth * scale) * 0.5f + 0.5f);
            int dy = (int)(((float)btnHeight - (float)imgHeight * scale) * 0.5f + 0.5f);
            this.image.setBounds(dx, dy, (int)((float)dx + (float)imgWidth * scale), (int)((float)dy + (float)imgHeight * scale));
            this.image.draw(canvas);
        }
    }
}

