/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.util.MonthDisplayHelper;
import com.mottimotti.android.widget.CalendarDay;
import com.mottimotti.android.widget.CalendarFilter;
import com.mottimotti.android.widget.CalendarTable;
import com.mottimotti.android.widget.DayState;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

class CalendarWeek {
    private final MonthDisplayHelper monthDisplayHelper;
    private List<CalendarDay> days = new ArrayList<CalendarDay>();
    private final boolean blockFutureDays;
    private final Calendar currentCalendar;
    private final Calendar helperCalendar;
    private List<Date> activeDates = new ArrayList<Date>();

    public CalendarWeek(CalendarTable table, int week) {
        this.monthDisplayHelper = table.getMonthDisplayHelper();
        this.blockFutureDays = table.isFutureDaysBlocked();
        this.activeDates = table.getActiveDates();
        this.currentCalendar = this.getCurrentCalendar();
        this.helperCalendar = this.getHelperCalendar();
        CalendarFilter filter = new CalendarFilter(this.monthDisplayHelper);
        Calendar startCalendar = filter.getStartCalendar();
        startCalendar.add(4, week);
        this.collectCalendarDays(startCalendar);
    }

    private void collectCalendarDays(Calendar startCalendar) {
        for (int i = 0; i < 7; ++i) {
            DayState dayState = this.getDayState(startCalendar);
            CalendarDay calendarDay = new CalendarDay(startCalendar.getTime(), dayState);
            this.days.add(calendarDay);
            startCalendar.add(5, 1);
            startCalendar.getTimeInMillis();
        }
    }

    private DayState getDayState(Calendar startCalendar) {
        if (this.activeDates.indexOf(startCalendar.getTime()) != -1) {
            return DayState.ACTIVE;
        }
        if (this.blockFutureDays) {
            return this.getFilteredDayState(startCalendar);
        }
        return this.getGeneralDayState(startCalendar);
    }

    private DayState getFilteredDayState(Calendar startCalendar) {
        Date currentDate = this.currentCalendar.getTime();
        int currentMonth = this.currentCalendar.get(2);
        int currentYear = this.currentCalendar.get(1);
        Date helperDate = this.helperCalendar.getTime();
        int helperMonth = this.helperCalendar.get(2);
        Date startDate = startCalendar.getTime();
        int startMonth = startCalendar.get(2);
        int startYear = startCalendar.get(1);
        DayState dayState = startYear <= currentYear ? (startDate.compareTo(currentDate) > 0 ? DayState.BLOCKED : (startDate.compareTo(helperDate) < 0 ? DayState.INACTIVE : (startDate.compareTo(helperDate) > 0 ? (startDate.compareTo(currentDate) < 0 ? (startMonth == helperMonth ? DayState.REGULAR : DayState.INACTIVE) : (startDate.compareTo(currentDate) == 0 ? (startMonth == currentMonth ? DayState.CURRENT : DayState.REGULAR) : DayState.BLOCKED)) : DayState.REGULAR))) : DayState.BLOCKED;
        return dayState;
    }

    private DayState getGeneralDayState(Calendar startCalendar) {
        Date currentDate = this.currentCalendar.getTime();
        int currentMonth = this.currentCalendar.get(2);
        Date helperDate = this.helperCalendar.getTime();
        int helperMonth = this.helperCalendar.get(2);
        Date startDate = startCalendar.getTime();
        int startMonth = startCalendar.get(2);
        DayState dayState = startDate.compareTo(helperDate) < 0 ? DayState.INACTIVE : (startDate.compareTo(helperDate) > 0 ? (startDate.compareTo(currentDate) < 0 ? (startMonth == helperMonth ? DayState.REGULAR : DayState.INACTIVE) : (startDate.compareTo(currentDate) == 0 ? (startMonth == currentMonth ? DayState.CURRENT : DayState.REGULAR) : (startMonth == helperMonth ? DayState.REGULAR : DayState.INACTIVE))) : DayState.REGULAR);
        return dayState;
    }

    private Calendar getCurrentCalendar() {
        Calendar mCalendar = Calendar.getInstance();
        mCalendar.set(11, 0);
        mCalendar.set(12, 0);
        mCalendar.set(13, 0);
        mCalendar.set(14, 0);
        mCalendar.getTimeInMillis();
        return mCalendar;
    }

    private Calendar getHelperCalendar() {
        Calendar mCalendar = Calendar.getInstance();
        mCalendar.set(1, this.monthDisplayHelper.getYear());
        mCalendar.set(2, this.monthDisplayHelper.getMonth());
        mCalendar.set(5, 1);
        mCalendar.set(11, 0);
        mCalendar.set(12, 0);
        mCalendar.set(13, 0);
        mCalendar.set(14, 0);
        mCalendar.getTimeInMillis();
        return mCalendar;
    }

    public List<CalendarDay> getDays() {
        return this.days;
    }
}

